C***** QTC058  REAL/COMPLEX FFT SCRAMBLE       REV 1.0     JAN 88
C
C  PURPOSE:
C       PERFORMS THE REAL/COMPLEX SCRAMBLE ALGORITHM.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                DEC 86          D.R. BENUA, QTC
C       MATH ADVANTAGE VERSION  JAN 88          R.D. COLEMAN, QTC
C          CHANGED SUBROUTINE NAMES AND HEADER DOCUMENTATION AND
C          REMOVED SCALING.
C
C  CALLING FORMAT:
C       CALL QTC058 (A, INC, N, IFLG, SRTAB, CRTAB)
C
C  PARAMETERS:
C
C       A       REAL INPUT/OUTPUT ARRAY OF LENGTH N.
C
C       INC     INTEGER INPUT SCALAR
C               STRIDE OF ARRAY A, MUST BE POSITIVE.
C
C       N       INTEGER INPUT SCALAR
C               LENGTH OF ARRAY A, MUST BE EVEN AND FACTORABLE AS
C               AS INTEGER POWERS OF 2, 3, 5, AND 7.
C
C       IFLG    INTEGER INPUT SCALAR
C               DIRECTION OF TRANSFORM, POSITIVE FOR
C               FORWARD, NEGATIVE FOR INVERSE.
C
C       SRTAB   REAL INPUT ARRAY OF LENGTH N/4
C               SINE VALUES.
C
C       CRTAB   REAL INPUT ARRAY OF LENGTH N/4
C               COSINE VALUES.
C
C  DESCRIPTION:
C       This routine implements the real/complex scramble agorithm
C       that permits a real FFT of length N to be computed with
C       a complex FFT of length N/2.  For an explanation of
C       this technique see E.O. Brigham, "The Fast Fourier Transform",
C       Prentice-Hall, 1974, pp. 167-169.
C
C       To compute a forward real FFT, this routine is called after
C       the complex FFT computation.   To compute the inverse FFT, this
C       routine is called first, followed by a complex inverse FFT.
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C---------------------------------------------------------------------
C
        SUBROUTINE QTC058 (A, INC, N, IFLG, SRTAB, CRTAB)
C
        REAL A(1), SRTAB(1), CRTAB(1)
        REAL AIH, AIL, ARH, ARL, BIMI, BIPI, BRMR, BRPR,
     &       CF, SF
        INTEGER INC, N, IFLG, I, IPIH, IPIL, IPRH, IPRL
C
        IPRL = 1
        IPIL = 1 + INC
C
C----------------------------
C  First Pair, special case
C----------------------------
C
        ARL = A(IPRL)
        AIL = A(IPIL)
C
        IF (IFLG .GE. 0) THEN
                A(IPRL) = 2.0 * (ARL + AIL)
                A(IPIL) = 2.0 * (ARL - AIL)
        ELSE
                A(IPRL) = ARL + AIL
                A(IPIL) = ARL - AIL
        ENDIF
C
C-------------
C  Main Loop
C-------------
C
        IPRH = 1 + N*INC
C
        DO 10 I=1,N/4
C
                IPRL = IPIL + INC
                IPIL = IPRL + INC
                ARL = A(IPRL)
                AIL = A(IPIL)
C
                IPIH = IPRH - INC
                IPRH = IPIH - INC
                ARH = A(IPRH)
                AIH = A(IPIH)
C
                BRPR = ARL + ARH
                BRMR = ARL - ARH
                BIPI = AIL + AIH
                BIMI = AIL - AIH
C
                CF = CRTAB(I)
                SF = SRTAB(I)
C
                A(IPRL) =  BRPR + CF*BIPI - SF*BRMR
                A(IPIL) =  BIMI - SF*BIPI - CF*BRMR
C
                A(IPRH) =  BRPR - CF*BIPI + SF*BRMR
                A(IPIH) = -BIMI - SF*BIPI - CF*BRMR
C
10      CONTINUE
C
        RETURN
        END
