C***** QTC061  BUILD LINKED LIST LOWER ADJNCY   REV1.0         JAN 88
C
C  PURPOSE:
C       BUILDS THE LINKED LIST LOWER ADJACENCY STRUCTURE FOR A GRAPH
C       GIVEN A LIST OF EDGES.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC061 (II, JJ, IHEAD, ITAIL, LLIST, M, N, NE, MAX, IERR)
C
C  PARAMETERS:
C       II      INTEGER INPUT VECTOR OF LENGTH M
C               CONTAINS A LIST OF NODES THAT ARE ONE END OF AN EDGE.
C
C       JJ      INTEGER INPUT VECTOR OF LENGTH M
C               CONTAINS A LIST OF NODES THAT ARE THE OTHER END OF THE
C               EDGE FROM THE CORRESPONDING NODE IN II.
C
C       IHEAD   INTEGER OUTPUT VECTOR OF LENGTH N
C               POINTERS TO THE HEAD OF THE LIST FOR EACH NODE.
C
C       ITAIL   INTEGER OUTPUT VECTOR OF LENGTH N
C               POINTERS TO THE TAIL OF THE LIST FOR EACH NODE.
C
C       LLIST   INTEGER OUTPUT VECTOR OF LENGTH MAX
C               CONTAINS THE LINKED LISTS IN THE LAST 2*NE ELEMENTS.
C
C       M       INTEGER INPUT SCALAR
C               ELEMENT COUNT FOR II AND JJ.
C
C       N       INTEGER INPUT SCALAR
C               NUMBER OF NODES IN THE GRAPH.
C
C       NE      INTEGER OUTPUT SCALAR
C               NUMBERS OF EDGES IN THE GRAPH.
C
C       MAX     INTEGER INPUT SCALAR
C               NUMBERS OF WORDS AVAILABLE IN THE ARRAY LLIST.
C
C       IERR    INTEGER OUTPUT SCALAR
C               COMPLETION CODE: IERR = 0 - NORMAL COMPLETION
C                                IERR = 1 - INVALID NODE NUMBER
C                                IERR = 2 - INSUFFICIENT SPACE IN LLIST
C
C  DESCRIPTION:
C       BUILDS THE LOWER ADJACENCY STRUCTURE FOR A GRAPH IN LINKED LIST
C       FORMAT GIVEN A LIST OF EDGES.  THE LIST OF EDGES IS DEFINED BY
C       THE ARRAY PAIR (II,JJ) WHERE THE PAIR (II(K),JJ(K)) REPRESENTS AN
C       EDGE CONNECTING NODE II(K) AND NODE JJ(K).  NOTE THAT THE PAIRS
C       (K,L) AND (L,K) DEFINE THE SAME EDGE.  REDUNDANT EDGES IN THE
C       LIST ARE IGNORED.  LIKEWISE, PAIRS THAT HAVE EQUAL NODES (II(K)
C       = JJ(K)) DO NOT DEFINE AN EDGE AND ARE IGNORED.  THUS, THE
C       NUMBER OF EDGES, NE, WILL ALWAYS BE LESS THAN OR EQUAL TO M.
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       QTC062
C
C  ERROR CONDITIONS:
C       IF A NODE NUMBER IS INVALID (<0 OR >N) OR IF THERE IS
C       INSUFFICIENT SPACE IN LLIST FOR THE LINKED LISTS, THEN
C       THE APPROPRIATE ERROR CODE IS SET AND THE ROUTINE IS ABORTED.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC061 (II, JJ, IHEAD, ITAIL, LLIST, M, N, NE, MAX,
     &                   IERR)
C
      INTEGER II(1), JJ(1), IHEAD(1), ITAIL(1), LLIST(1), M, N, NE,
     &        MAX, IERR
      INTEGER I, J, K
C
C-----------------------------------------------------------------------
C
      NE = 0
C
      DO 120 K = 1, M
         I = II(K)
         J = JJ(K)
C
         IF (I .LE. 0 .OR. I .GT. N) THEN
            IERR = 1
            GO TO 800
         ENDIF
C
         IF (J .LE. 0 .OR. J .GT. N) THEN
            IERR = 1
            GO TO 800
         ENDIF
C
         IF      (I .LT. J) THEN
            CALL QTC062 (I, J, IHEAD, ITAIL, LLIST, N, NE, MAX, IERR)
         ELSE IF (I .GT. J) THEN
            CALL QTC062 (J, I, IHEAD, ITAIL, LLIST, N, NE, MAX, IERR)
         ENDIF
C
         IF (IERR .NE. 0) GO TO 800
  120 CONTINUE
C
C  EXIT ROUTINE
C
  800 CONTINUE
      RETURN
      END
