C***** QTC062  INSERT EDGE IN LINKED LIST      REV 1.0         JAN 88
C
C  PURPOSE:
C       INSERTS AN EDGE OF A GRAPH INTO THE LINKED LIST LOWER ADJACENCY
C       STRUCTURE FOR THE GRAPH.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC062 (I, J, IHEAD, ITAIL, LLIST, N, NE, MAX, IERR)
C
C  PARAMETERS:
C       I       INTEGER INPUT SCALAR
C               SMALLEST NODE NUMBER OF EDGE (0 < I < J).
C
C       J       INTEGER INPUT SCALAR
C               LARGEST NODE NUMBER OF EDGE (I < I =< N).
C
C       IHEAD   INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               POINTERS TO THE HEAD OF THE LIST FOR EACH NODE.
C
C       ITAIL   INTEGER INPUT/OUTPUT VECTOR OF LENGTH N
C               POINTERS TO THE TAIL OF THE LIST FOR EACH NODE.
C
C       LLIST   INTEGER INPUT/OUTPUT VECTOR OF LENGTH MAX
C               CONTAINS THE LINKED LISTS IN THE LAST 2*NE ELEMENTS.
C
C       N       INTEGER INPUT SCALAR
C               NUMBER OF NODES IN THE GRAPH.
C
C       NE      INTEGER INPUT/OUTPUT SCALAR
C               NUMBERS OF EDGES IN THE LINKED LIST.
C
C       MAX     INTEGER INPUT SCALAR
C               NUMBERS OF WORDS AVAILABLE IN THE ARRAY LLIST.
C
C       IERR    INTEGER OUTPUT SCALAR
C               COMPLETION CODE: IERR = 0 - NORMAL COMPLETION
C                                IERR = 2 - INSUFFICIENT SPACE IN LLIST
C
C  DESCRIPTION:
C       INSERTS AN EDGE OF A GRAPH INTO THE LINKED LIST LOWER ADJACENCY
C       STRUCTURE FOR THE GRAPH.  IF THE EDGE IS ALREADY IN THE LIST,
C       THEN NO ACTION IS TAKEN.  OTHERWISE, THE EDGE IS INSERTED IN THE
C       LIST AND THE PARAMETERS IHEAD, ITAIL, LLIST AND NE ARE UPDATED.
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       IF THERE IS INSUFFICIENT SPACE IN LLIST FOR THE LINKED LISTS,
C       THEN THE COMPLETION CODE IS SET TO 2 AND THE ROUTINE IS ABORTED.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC062 (I, J, IHEAD, ITAIL, LLIST, N, NE, MAX, IERR)
C
      INTEGER I, J, IHEAD(1), ITAIL(1), LLIST(1), N, NE, MAX, IERR
      INTEGER K, L, LENT, LHD, LLNK, LTL
C
C-----------------------------------------------------------------------
C
C     -----------------------------------
C     IF NE = 0, INITIALIZE IHEAD & ITAIL
C     -----------------------------------
C
      IF (NE .EQ. 0) THEN
         DO 110 K = 1, N
            IHEAD(K) = 0
            ITAIL(K) = 0
  110    CONTINUE
      ENDIF
C
C     --------------
C     INITIALIZATION
C     --------------
C
      LHD  = IHEAD(I)
      LTL  = ITAIL(I)
      LLNK = MAX - 2 * NE
      LENT = LLNK - 1
      IF (LHD .NE. 0) GO TO 200
C
C     -----------------
C     INITIALIZE LIST I
C     -----------------
C
      IF (LENT .LE. 0) GO TO 820
C
      NE = NE + 1
      LLIST(LENT) = J
      LLIST(LLNK) = 0
      IHEAD(I)    = LENT
      ITAIL(I)    = LENT
      GO TO 800
C
C     ----------
C     WHERE NOW?
C     ----------
C
  200 CONTINUE
      IF (J .LT. LLIST(LHD)) GO TO 300
      IF (J .GT. LLIST(LTL)) GO TO 400
      IF (J .EQ. LLIST(LHD) .OR. J .EQ. LLIST(LTL)) GO TO 800
      GO TO 500
C
C     -------------------------
C     INSERT AT START OF LIST I
C     -------------------------
C
  300 CONTINUE
      IF (LENT .LE. 0) GO TO 820
C
      NE = NE + 1
      LLIST(LENT) = J
      LLIST(LLNK) = LHD
      IHEAD(I)    = LENT
      GO TO 800
C
C     -----------------------
C     INSERT AT END OF LIST I
C     -----------------------
C
  400 CONTINUE
      IF (LENT .LE. 0) GO TO 820
C
      NE = NE + 1
      LLIST(LENT)  = J
      LLIST(LLNK)  = 0
      LLIST(LTL+1) = LENT
      ITAIL(I)     = LENT
C
C     -------------
C     SEARCH LIST I
C     -------------
C
  500 CONTINUE
      K = LHD
  510 CONTINUE
         L = K
         K = LLIST(L+1)
         IF (J .EQ. LLIST(K)) GO TO 800
         IF (J .GT. LLIST(K)) GO TO 510
C
C     --------------------------
C     INSERT IN MIDDLE OF LIST I
C     --------------------------
C
      IF (LENT .LE. 0) GO TO 820
C
      NE = NE + 1
      LLIST(LENT) = J
      LLIST(LLNK) = K
      LLIST(L+1)  = LENT
C
C     -------------
C     NORMAL RETURN
C     -------------
C
  800 CONTINUE
      IERR = 0
      RETURN
C
C     ---------------------------------
C     ERROR RETURN - INSUFFICIENT SPACE
C     ---------------------------------
C
  820 CONTINUE
      IERR = 2
      RETURN
C
      END
