C***** QTC065  CONVERT LOWER TO FULL ADJACENCY REV 1.0         JAN 88
C
C  PURPOSE:
C       CONVERTS A LOWER ADJACENCY STRUCTURE TO A FULL ADJACENCY
C       STRUCTURE IN-PLACE.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC065 (IADJ, JADJ, IWRK, N, NE)
C
C  PARAMETERS:
C       IADJ    INTEGER INPUT/OUTPUT VECTOR OF LENGTH N+1
C               POINTERS INTO THE ADJACENCY VECTOR.
C
C       JADJ    INTEGER INPUT/OUTPUT VECTOR OF LENGTH 2*NE
C               ON INPUT, THE LOWER ADJACENCY STRUCTURE OF THE GRAPH
C               IS STORED IN THE FIRST NE ELEMENTS.  ON OUTPUT, THE
C               FULL ADJACENCY STRUCTURE IS STORED IN THE FIRST 2*NE
C               ELEMENTS.
C
C       IWRK    INTEGER SCRATCH VECTOR OF LENGTH N
C
C       N       INTEGER INPUT SCALAR
C               NUMBER OF NODES IN THE GRAPH.
C
C       NE      INTEGER OUTPUT SCALAR
C               NUMBERS OF EDGES IN THE GRAPH.
C
C  DESCRIPTION:
C       CONVERTS A LOWER ADJACENCY STRUCTURE TO A FULL ADJACENCY
C       STRUCTURE IN-PLACE.
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC065 (IADJ, JADJ, IWRK, N, NE)
C
      INTEGER IADJ(1), JADJ(1), IWRK(1), N, NE
      INTEGER I, J, K, K1, K2, KNT
C
C-----------------------------------------------------------------------
C
      DO 110 I = 1, N
         IWRK(I) = IADJ(I+1) - IADJ(I)
  110 CONTINUE
C
      DO 120 K = 1, NE
         I = JADJ(K)
         IWRK(I) = IWRK(I) + 1
  120 CONTINUE
C
      K   = 1
      DO 130 I = 1, N
         KNT = IWRK(I)
         IWRK(I) = K
         K = K + KNT
  130 CONTINUE
C
      DO 150 I = N-1, 2, -1
         K1 = IADJ(I)
         K2 = IADJ(I+1) - 1
         IF (K2 .GE. K1) THEN
            J = IWRK(I+1) - 1
            IF (J .EQ. K2) GO TO 160
            DO 140 K = K2, K1, -1
               JADJ(J) = JADJ(K)
               J = J - 1
  140       CONTINUE
         ENDIF
  150 CONTINUE
C
  160 CONTINUE
      DO 170 I = 1, N
         IADJ(I) = IWRK(I)
  170 CONTINUE
      IADJ(N+1) = 2 * NE + 1
C
      DO 190 I = 1, N
         K1 = IADJ(I)
         K2 = IADJ(I+1) - 1
         IF (K2 .GE. K1) THEN
            DO 180 K = K1, K2
               J = JADJ(K)
               IF (J .GT. I) THEN
                  JADJ(IWRK(J)) = I
                  IWRK(J) = IWRK(J) + 1
               ENDIF
  180       CONTINUE
         ENDIF
  190 CONTINUE
C
      RETURN
      END
