C***** QTC068  ROOTED LEVEL STRUCTURE          REV 1.0         JAN 88
C
C  PURPOSE:
C       GENERATES THE LEVEL STRUCTURE ROOTED AT THE INPUT NODE CALLED
C       IROOT.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          THOMAS COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC068 (IROOT, IADJ, JADJ, MASK, NLVL, ILS, JLS)
C
C  PARAMETERS:
C       IROOT   INTEGER INPUT SCALAR
C               THE NODE AT WHICH THE LEVEL STRUCTURE IS TO
C               BE ROOTED
C
C       IADJ    INTEGER INPUT VECTOR OF LENGTH N+1
C               CONTAINS POINTERS INTO THE ADJACENCY VECTOR, JADJR.
C               IADJ(N+1) = 2*NE+1, WHERE NE IS THE NUMBER OF EDGES.
C
C       JADJ    INTEGER INPUT VECTOR OF LENGTH 2*NE
C               CONTAINS THE ADJACENCY STRUCTURE OF THE GRAPH.
C
C       MASK    INTEGER INPUT VECTOR OF LENGTH N
C               IS USED TO SPECIFY THE SECTION SUBGRAPH.  NODES
C               WITH MASK(I)=0 ARE IGNORED
C
C       NLVLS   INTEGER OUTPUT SCALAR
C               THE NUMBER OF LEVELS IN THE LEVEL STRUCTURE ROOTED
C               AT THE NODE IROOT
C
C       ILS     INTEGER OUTPUT VECTOR
C               POINTERS INTO JLS
C
C       JLS     INTEGER OUTPUT VECTOR
C               THE LEVEL STRUCTURE
C
C  DESCRIPTION:
C       THIS SUBROUTINE GENERATES A LEVEL STRUCTURE OF THE CONNECTED
C       COMPONENT SPECIFIED BY THE INPUT PARAMETERS IROOT, MASK, IADJ,
C       AND JADJ.  ON EXIT FROM THE SUBROUTINE, THE LEVEL STRUCTURE
C       GENERATED IS ROOTED AT IROOT, AND IS CONTAINED IN THE ARRAY
C       PAIR (ILS, JLS).
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC068 (IROOT, IADJ, JADJ, MASK, NLVL, ILS, JLS)
C
      INTEGER IROOT, IADJ(1), JADJ(1), MASK(1), NLVL, ILS(1), JLS(1),
     &        I, ICCSIZ, J, JSTOP, JSTRT, LVLBEG, LVLEND, LVLSIZ, NBR,
     &        NODE
C
C-----------------------------------------------------------------------
C
C     --------------
C     INITIALIZATION
C     --------------
C
      MASK(IROOT) = 0
      JLS(1)      = IROOT
      NLVL        = 0
      LVLEND      = 0
      ICCSIZ      = 1
C
C     -----------------------------------------------------
C     LVLBEG IS THE POINTER TO THE BEGINNING OF THE CURRENT
C     LEVEL AND LVLEND POINTS TO THE END OF THIS LEVEL.
C     -----------------------------------------------------
C
  100 CONTINUE
      LVLBEG = LVLEND + 1
      LVLEND = ICCSIZ
      NLVL   = NLVL + 1
      ILS(NLVL) = LVLBEG
C
C     ------------------------------------------------
C     GENERATE THE NEXT LEVEL BY FINDING ALL THE MASKED
C     NEIGHBORS OF NODES IN THE CURRENT LEVEL
C     ------------------------------------------------
C
      DO 120 I = LVLBEG, LVLEND
         NODE  = JLS(I)
         JSTRT = IADJ(NODE)
         JSTOP = IADJ(NODE + 1) -1
         IF (JSTOP .GE. JSTRT) THEN
            DO 110 J = JSTRT, JSTOP
               NBR = JADJ(J)
               IF (MASK(NBR) .NE. 0) THEN
                  ICCSIZ      = ICCSIZ + 1
                  JLS(ICCSIZ) = NBR
                  MASK(NBR)   = 0
               ENDIF
  110       CONTINUE
         ENDIF
  120 CONTINUE
C
C     ------------------------------------------
C     COMPUTE THE CURRENT LEVEL WIDTH.
C     IF IT IS NONZERO, GENERATE THE NEXT LEVEL.
C     ------------------------------------------
C
      LVLSIZ = ICCSIZ - LVLEND
      IF ( LVLSIZ .GT. 0 ) GO TO 100
C
C     ------------------------------------------------------
C     RESET MASK TO ONE FOR THE NODES IN THE LEVEL STRUCTURE.
C     ------------------------------------------------------
C
      ILS(NLVL+1) = LVLEND + 1
      DO 210 I = 1, ICCSIZ
         NODE = JLS(I)
         MASK(NODE) = 1
  210 CONTINUE
C
      RETURN
      END
