C***** QTC076  FIND ENVELOPE STRUCTURE         REV 1.0         JAN 88
C
C  PURPOSE:
C       FINDS THE ENVELOPE STRUCTURE OF A PERMUTED MATRIX
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          THOMAS COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC076 (N, IADJ, JADJ, IPERMR, IPERMF, ICP, NS, NBANDW)
C
C  PARAMETERS:
C       N       INTEGER INPUT SCALAR
C               NUMBER OF EQUATIONS.
C
C       IADJ    INTEGER INPUT VECTOR OF LENGTH N+1
C               POINTERS INTO THE ADJACENCY VECTOR.  IADJ(N+1) = 2*NE+1,
C               WHERE NE IS THE NUMBER OF EDGES.
C
C       JADJ    INTEGER INPUT VECTOR OF LENGTH 2*NE
C               THE ADJACENCY STRUCTURE OF THE GRAPH OF THE MATRIX.
C
C       IPERMR  INTEGER INPUT VECTOR OF LENGTH N
C               CONTAINS THE REVERSE PERMUTATION VECTOR.
C
C       IPERMF  INTEGER INPUT VECTOR OF LENGTH N
C               CONTAINS THE FORWARD PERMUTATION VECTOR.
C
C       ICP     INTEGER OUTPUT VECTOR OF LENGTH N+1
C               COLUMN POINTER VECTOR.
C
C       NS      INTEGER OUTPUT SCALAR
C               THE NUMBER OF ELEMENTS IN THE LOWER ENVELOPE.
C               NS WILL ALWAYS BE EQUAL TO ICP(N+1)-1.
C
C       NBANDW  INTEGER OUTPUT SCALAR
C               BANDWIDTH OF THE REORDERED MATRIX.
C
C  DESCRIPTION:
C       THIS SUBROUTINE ACCEPTS AS INPUT THE GRAPH STORED IN IADJ AND
C       JADJ, ALONG WITH THE FORWARD AND REVERSE PERMUTATION VECTORS
C       (IPERMF AND IPERMR).  THE SUBROUTINE COMPUTES THE COMPONENTS
C       OF THE POINTER ARRAY (ICP).  ALSO RETURNED ARE THE VALUE OF
C       THE  BANDWIDTH (NBANDW) AND THE ENVELOPE SIZE (NS).
C
C  REFERENCE:
C       Alan George and Joseph W-H. Liu.  1981.  Computer Solution of
C       Large Sparse Positive Definite Systems, Prentice-Hall, Englewood
C       Cliffs, N.J. (1981)
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC076 (N, IADJ, JADJ, IPERMR, IPERMF, ICP, NS, NBANDW)
C
      INTEGER N, IADJ(1), JADJ(1), IPERMR(1), IPERMF(1), ICP(1), NS,
     &        NBANDW, I, IBAND, IFIRST, IPERM, J, JSTOP, JSTRT, NABOR
C
C-----------------------------------------------------------------------
C
      NBANDW = 0
      NS     = 1
      DO 120 I  = 1, N
         ICP(I) = NS
         IPERM  = IPERMR(I)
         JSTRT  = IADJ(IPERM)
         JSTOP  = IADJ(IPERM + 1) - 1
C
C        -------------------------------
C        FIND THE FIRST NONZERO IN ROW I
C        -------------------------------
C
         IFIRST  = I
C
         IF (JSTOP .GE. JSTRT) THEN
            DO 110 J = JSTRT, JSTOP
               NABOR = JADJ(J)
               NABOR = IPERMF(NABOR)
               IF (NABOR .LT. IFIRST) IFIRST = NABOR
  110       CONTINUE
         ENDIF
C
         IBAND = I - IFIRST
         NS    = NS + IBAND + 1
         IF (NBANDW .LT. IBAND) NBANDW = IBAND
  120 CONTINUE
C
      ICP(N+1) = NS
      NS       = NS - 1
C
      RETURN
      END
