C***** QTC100  INSERT REAL DATA INTO ENVELOPE  REV 1.0         JAN 88
C
C  PURPOSE:
C       INSERTS THE NONZERO ELEMENTS OF A REAL MATRIX INTO AN ENVELOPE
C       DATA STRUCTURE.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC100 (II, JJ, VV, IPERMF, ICP, S, M, N, IERR)
C
C  PARAMETERS:
C       II      INTEGER INPUT VECTOR OF LENGTH M
C               LIST OF ROW NUMBERS OF THE NONZERO ELEMENTS.
C
C       JJ      INTEGER INPUT VECTOR OF LENGTH M
C               LIST OF COLUMN NUMBERS OF THE NONZERO ELEMENTS.
C
C       VV      REAL INPUT VECTOR OF LENGTH M
C               LIST OF VALUES OF THE NONZERO ELEMENTS.
C
C       IPERMF  INTEGER INPUT VECTOR OF LENGTH N
C               FORWARM PERMUTATION VECTOR.
C
C       ICP     INTEGER INPUT VECTOR OF LENGTH N+1
C               ENVELOPE COLUMN POINTERS.
C
C       S       REAL OUTPUT VECTOR OF LENGTH NS
C               ENVELOPE DATA ARRAY.  NS = ICP(N+1) - 1
C
C       M       INTEGER INPUT SCALAR
C               ELEMENT COUNT FOR II, JJ , AND VV.
C
C       N       INTEGER INPUT SCALAR
C               ORDER OF THE MATRIX.
C
C       IERR    INTEGER OUTPUT SCALAR
C               COMPLETION CODE: IERR = 0 - NORMAL COMPLETION
C                                IERR = 1 - INVALID ROW OR COLUMN NUMBER
C                                IERR = 2 - ELEMENT NOT IN ENVELOPE
C
C  DESCRIPTION:
C       THE ARRAY S IS FIRST FILLED WITH ZEROS, THEN THE NONZERO
C       ELEMENTS SPECIFIED BY II, JJ, AND VV ARE INSERTED INTO S.  IF AN
C       ELEMENT IS DEFINED MORE THAN ONCE, THE LAST DEFINITION IS USED.
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       IF A ROW OR COLUMN NUMBER IS INVALID (<0 OR >N) OR IF AN
C       ELEMENT IS SPECIFIED THAT IS NOT CONTAINED WITHIN THE ENVELOPE,
C       THEN THE APPROPRIATE ERROR CODE IS SET AND THE ROUTINE IS
C       ABORTED.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC100 (II, JJ, VV, IPERMF, ICP, S, M, N, IERR)
C
      INTEGER II(1), JJ(1), IPERMF(1), ICP(1), M, N, IERR
      REAL    VV(1), S(1)
      INTEGER I, ITEMP, J, K, L, NS
C
C-----------------------------------------------------------------------
C
      NS = ICP(N+1) - 1
      CALL VCLR (S, 1, NS)
C
      DO 110 L = 1, M
         I = II(L)
         J = JJ(L)
C
         IF (I .LE. 0 .OR. I .GT. N) GO TO 810
         IF (J .LE. 0 .OR. J .GT. N) GO TO 810
C
         I = IPERMF(I)
         J = IPERMF(J)
C
         IF (J .LT. I) THEN
            ITEMP = I
            I     = J
            J     = ITEMP
         ENDIF
C
         K = ICP(J) + J - I
         IF (K .GE. ICP(J+1)) GO TO 820
C
         S(K) = VV(L)
  110 CONTINUE
C
      IERR = 0
      RETURN
C
  810 CONTINUE
      IERR = 1
      RETURN
C
  820 CONTINUE
      IERR = 2
      RETURN
C
      END
