C***** QTC107  PERMUTE ROWS OF COMPLEX MATRIX  REV 1.0         JAN 88
C
C  PURPOSE:
C       PERMUTES THE ROWS OF A COMPLEX MATRIX IN-PLACE.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL QTC107 (BX, N, M, IPERMF, IPERMR)
C
C  PARAMETERS:
C       BX      COMPLEX INPUT/OUTPUT MATRIX OF DIMENSION N BY M
C               MATRIX TO BE PERMUTED.
C
C       N       INTEGER INPUT SCALAR
C               NUMBER OF ROWS IN MATRIX.
C
C       M       INTEGER INPUT SCALAR
C               NUMBER OF COLUMNS IN MATRIX.
C
C       IPERMF  INTEGER INPUT VECTOR OF LENGTH N
C               FORWARD PERMUTATION VECTOR.
C
C       IPERMR  INTEGER INPUT VECTOR OF LENGTH N
C               REVERSE PERMUTATION VECTOR.
C
C  DESCRIPTION:
C       PERMUTES THE ROWS OF A COMPLEX MATRIX IN-PLACE.
C
C  SUBPROGRAMS CALLED:
C       NONE
C
C  ERROR CONDITIONS:
C       NONE
C
C-----------------------------------------------------------------------
C
      SUBROUTINE QTC107 (BX, N, M, IPERMF, IPERMR)
C
      REAL    BX(1)
      INTEGER M, N, IPERMF(1), IPERMR(1)
      REAL    RTEMP1, RTEMP2
      INTEGER I, I1, I2, J, J1, J2, N2
C
C-----------------------------------------------------------------------
C
      IF (M .GT. 1) GO TO 200
C
      I1 = 1
      I2 = 2
      DO 120 I = 1, N
  110    CONTINUE
         J = IPERMF(I)
C
         IF (J .NE. I) THEN
            J2 = J + J
            J1 = J2 - 1
            RTEMP1    = BX(I1)
            RTEMP2    = BX(I2)
            BX(I1)    = BX(J1)
            BX(I2)    = BX(J2)
            BX(J1)  = RTEMP1
            BX(J2)  = RTEMP2
            IPERMF(I) = IPERMF(J)
            IPERMF(J) = J
            GO TO 110
         ENDIF
C
         I1 = I1 + 2
         I2 = I2 + 2
  120 CONTINUE
      GO TO 300
C
  200 CONTINUE
      N2 = N + N
      I1 = 1
      I2 = 2
      DO 220 I = 1, N
  210    CONTINUE
         J = IPERMF(I)
C
         IF (J .NE. I) THEN
            J2 = J + J
            J1 = J2 - 1
            CALL VSWAP (BX(I1), N2, BX(J1), N2, M)
            CALL VSWAP (BX(I2), N2, BX(J2), N2, M)
            IPERMF(I) = IPERMF(J)
            IPERMF(J) = J
            GO TO 210
         ENDIF
C
         I1 = I1 + 2
         I2 = I2 + 2
  220 CONTINUE
C
  300 CONTINUE
      DO 310 I = 1, N
         IPERMF(IPERMR(I)) = I
  310 CONTINUE
C
      RETURN
      END
