C*****  QTC110                                MATH ADVANTAGE REL 3.0
      SUBROUTINE QTC110(P, QP, K, QK, SVK, SR, SI, U,
     & V, A, B, C, D, A1, A3, A7, E, F, G,
     & H, SZR, SZI, LZR, LZI, ETA, ARE, MRE, N, NN, L2, NZ)
C COMPUTES UP TO L2 FIXED SHIFT K-POLYNOMIALS,
C TESTING FOR CONVERGENCE IN THE LINEAR OR QUADRATIC
C CASE.  INITIATES ONE OF THE VARIABLE SHIFT
C ITERATIONS AND RETURNS WITH THE NUMBER OF ZEROS
C FOUND.
C L2 - LIMIT OF FIXED SHIFT STEPS
C NZ - NUMBER OF ZEROS FOUND
      DOUBLE PRECISION P(101), QP(101), K(101),
     & QK(101), SVK(101), U, V, A, B, C, D,
     & A1, A3, A7, E, F, G, H, SZR, SZI,
     & LZR, LZI, SR, SI, SVU, SVV, UI, VI, S
      REAL BETAS, BETAV, OSS, OVV, SS, VV, TS, TV,
     & OTS, OTV, TVV, TSS, ETA, ARE, MRE
      INTEGER N, NN, L2, NZ, TYPE, I, J, IFLAG,
     & VPASS, SPASS, VTRY, STRY
C
      VPASS = 0
      SPASS = 0
      VTRY = 0
      STRY = 0
      NZ = 0
      BETAV = 0.25
      BETAS = 0.25
      OSS = SR
      OVV = V
C EVALUATE POLYNOMIAL BY SYNTHETIC DIVISION
      CALL QTC116 (NN, U, V, P, QP, A, B)
      CALL QTC113 (K, QK, U,
     & V, A, B, C, D, A1, A3, A7, E, F, G,
     & H, ETA, N, TYPE)
      DO 80 J = 1,L2
C CALCULATE NEXT K POLYNOMIAL AND ESTIMATE V
        CALL QTC114 (QP, K, QK,
     &   A, B, A1, A3, A7,
     &   ETA, N, TYPE)
        CALL QTC113 (K, QK, U,
     &   V, A, B, C, D, A1, A3, A7, E, F, G,
     &   H, ETA, N, TYPE)
        CALL QTC115 (P, K, U,
     &   V, A, B, C, D, A1, A3, A7, F, G,
     &   H, N, NN, TYPE,
     &   UI, VI)
        VV = VI
C ESTIMATE S
        SS = 0.0
        IF (K(N) .NE. 0.D0) SS = -P(NN)/K(N)
        TV = 1.0
        TS = 1.0
        IF (J .EQ. 1 .OR. TYPE .EQ. 3) GO TO 70
C COMPUTE RELATIVE MEASURES OF CONVERGENCE OF S AN V
C SEQUENCES
        IF (VV.NE.0.0) TV = ABS((VV-OVV)/VV)
        IF (SS.NE.0.0) TS = ABS((SS-OSS)/SS)
C IF DECREASING, MULTIPLY TWO MOST RECENT
C CONVERGENCE MEASURES
        TVV = 1.0
        IF (TV.LT.OTV) TVV = TV*OTV
        TSS = 1.0
        IF (TS.LT.OTS) TSS = TS*OTS
C COMPARE WITH CONVERGENCE CRITEREA
        IF (TVV.LT.BETAV) THEN
           VPASS = 1
        ELSE
           VPASS = 0
        ENDIF
        IF (TSS.LT.BETAS) THEN
           SPASS = 1
        ELSE
           SPASS = 0
        ENDIF
        IF ((SPASS.NE.1).OR.(VPASS.NE.1)) GO TO 70
C AT LEAST ONE SEQUENCE HAS PASSED THE CONVERGENCE
C TEST.  STORE VARIABLES BEFORE ITERATING
        SVU = U
        SVV = V
        DO 10 I=1,N
          SVK(I) = K(I)
   10   CONTINUE
        S = SS
C CHOOSE ITERATION ACCORDING TO THE FASTEST
C CONVERGENCE SEQUENCE
        VTRY = 0
        STRY = 0
        IF ((SPASS.EQ.1) .AND. ((VPASS.EQ.0) .OR.
     &   (TSS.LT.TVV))) GO TO 40
   20   CALL QTC111 (P, QP, K, QK, U,
     &   V, A, B, C, D, A1, A3, A7, E, F, G,
     &   H, SZR, SZI, LZR, LZI, ETA, ARE, MRE, N, NN, UI,
     &   VI, NZ)
        IF (NZ.GT.0) RETURN
C QUADRATIC ITEATION HAS FAILED.  FLAG THAT IT HAS
C BEEN TRIED AND DECREASE THE CONVERGENCE CRITERION
        VTRY = 1
        BETAV = BETAV*0.25
C TRY LINEAR ITERATION IF IT HAS NOT BEEN TRIED AND
C THE S SEQUENCE IS CONVERGING
        IF ((STRY.EQ.1) .OR. (SPASS.NE.1)) GO TO 50
        DO 30 I=1,N
          K(I) = SVK(I)
   30   CONTINUE
   40   CALL QTC112 (P, QP, K, QK, SVK,
     &   SZR, SZI, ETA, ARE, MRE, N, NN, S,
     &   NZ, IFLAG)
        IF (NZ.GT.0) RETURN
C LINEAR ITERATION HAS FAILED.  FLAG THAT IT HAS BEEN
C TRIED AND DECREASE THE CONVERGENCE CRITERION
        STRY = 1
        BETAS = BETAS*0.25
        IF (IFLAG.EQ.0) GO TO 50
C IF LINEAR ITERATION SIGNALS AN ALMOST DOUBLE REAL
C ZERO ATTEMPT QUADRTIC ITERATION
        UI = -(S+S)
        VI = S*S
        GO TO 20
C RESTORE VARIABLES
   50   U = SVU
        V = SVV
        DO 60 I=1,N
          K(I) = SVK(I)
   60   CONTINUE
C TRY QUADRATIC ITERATION IF IT HAS NOT BEEN TRIED
C AND THE V SEQUENCE IS CONVERGING
        IF ((VPASS.EQ.1) .AND. (VTRY.NE.1)) GO TO 20
C RECOMPUTE QP AND SCALAR VALUES TO CONTINUE THE
C SECOND STAGE
        CALL QTC116(NN, U, V, P, QP, A, B)
        CALL QTC113(K, QK, U,
     &   V, A, B, C, D, A1, A3, A7, E, F, G,
     &   H, ETA, N, TYPE)
   70   OVV = VV
        OSS = SS
        OTV = TV
        OTS = TS
   80 CONTINUE
      RETURN
      END
