C*****  RFFT2F  Real-to-Complex Forward 2-D FFT      MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RFFT2F (A,C,NRC,NCC)
C
C       where,
C
C       A       Real input/output matrix.
C
C       C       Complex output matrix.
C
C       NRC     Integer input number of rows.
C
C       NCC     Integer input number of columns.
C
C
C  DESCRIPTION
C
C       This routine performs a real-to-complex two-dimensional
C       forward FFT on the data stored in matrix A.  It performs
C       the same operation as RFFT2D but the results are stored
C       in another matrix, C.  The result will be in a special
C       packed complex array form, occupying the same NRC by NCC
C       locations of C.  Array A will be modified.
C
C       These results are not properly scaled and may be scaled
C       using VSMUL to multiply by 1/(2*NRC*NCC).
C
C       Both NRC and NCC must be powers of two.
C
C       The array format on output of Forward FFT is:
C
C                           Columns
C               1     2     3     4     5     6        NCC-1  NCC
C              ----  ----  ----  ----  ----  ----       ----  ----
C       Row 1: real  real  real  imag  real  imag  ...  real  imag
C       Row 2: real  real  real  imag  real  imag  ...  real  imag
C
C       Row 3: real  real  real  real  real  real  ...  real  real
C       Row 4: imag  imag  imag  imag  imag  imag  ...  imag  imag
C
C       Row 5: real  real  real  real  real  real  ...  real  real
C       Row 6: imag  imag  imag  imag  imag  imag  ...  imag  imag
C               ..    ..    ..    ..    ..    ..   ...   ..    ..
C               ..    ..    ..    ..    ..    ..   ...   ..    ..
C               ..    ..    ..    ..    ..    ..   ...   ..    ..
C               ..    ..    ..    ..    ..    ..   ...   ..    ..
C       NRC-1: real  real  real  real  real  real  ...  real  real
C       NRC:   imag  imag  imag  imag  imag  imag  ...  imag  imag
C
C       Notice that the first two rows are different from the rest.
C       The first two rows each resemble outputs of a real FFT.  Refer
C       to RFFTSC for a description of the special packed complex
C       format. Note, though, that the second row contains what would
C       have been in the NRC+1 row, had there been room for an NRC+1
C       row.
C
C       Rows 2 through NRC-1 resemble outputs of a complex FFT, in
C       pairs of rows.  For example, in rows 2 and 3, the first element
C       of row 2 is the first real of the complex FFT output and the
C       first element of row 4 is the first imaginary of the complex FFT
C       output.
C
C       Refer to Appendix B for machine dependent notes.
C
C
C  REFERENCE
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RFFT2F (A,C,16,16)
C
C       Input Operands:
C
C       A =    2.0  2.0 ... for 16 columns total 2.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C
C       Output Operands:
C
C       C =   64.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C             64.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C
C
C  HISTORY
C         1) Feb 87     L. Shanbeck      Original.
C
      SUBROUTINE RFFT2F(A,C,NRC,NCC)
C
      REAL A(1),C(1),B
      INTEGER NRC,NCC,I,IC
      IF (NRC.LE.0 .OR. NCC.LE.0) GOTO 900
      B = 0.5
C
C     DO FORWARD RFFT2D
C
C --- COLUMNS
      IC = 1
      DO 200 I = 1,NCC*NRC,NRC
        CALL QTC019(A(I),NRC,IC,1)
200   CONTINUE
C
C --- ROWS
      IC = NRC
      CALL QTC019(A(1),NCC,IC,1)
      CALL QTC019(A(2),NCC,IC,1)
      CALL VMOV(A,1,C,1,NCC*NRC)
      CALL CVSMUL(C(1),IC,B,C(1),IC,NCC)
      DO 100 I = 3, NRC, 2
        CALL QTC018(C(I),NCC,IC,1)
100   CONTINUE
900   RETURN
      END
