C*****  RFFT2I  Complex-to-Real Inverse 2-D FFT     MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RFFT2I (A,C,NRC,NCC)
C
C       where,
C
C       A       Complex input matrix.
C
C       C       Real output matrix.
C
C       NRC     Integer input number of rows.
C
C       NCC     Integer input number of columns.
C
C
C  DESCRIPTION
C
C       This routine performs complex-to-real two-dimensional
C       inverse FFT on the data stored in matrix A.  It performs
C       the same operation as RFFT2D but the results are stored
C       in another matrix, C.  The input must be in a special
C       packed complex array form, occupying the same NRC by NCC
C       locations of A.
C
C       The results are stored as real values in matrix C and do not
C       need to be scaled.
C
C       Both NRC and NCC must be powers of two.
C
C       The array format on input to the inverse FFT is:
C
C                           Columns
C               1     2     3     4     5     6        NCC-1  NCC
C              ----  ----  ----  ----  ----  ----       ----  ----
C       Row 1: real  real  real  imag  real  imag  ...  real  imag
C       Row 2: real  real  real  imag  real  imag  ...  real  imag
C
C       Row 3: real  real  real  real  real  real  ...  real  real
C       Row 4: imag  imag  imag  imag  imag  imag  ...  imag  imag
C
C       Row 5: real  real  real  real  real  real  ...  real  real
C       Row 6: imag  imag  imag  imag  imag  imag  ...  imag  imag
C               ..    ..    ..    ..    ..    ..   ...   ..    ..
C               ..    ..    ..    ..    ..    ..   ...   ..    ..
C               ..    ..    ..    ..    ..    ..   ...   ..    ..
C               ..    ..    ..    ..    ..    ..   ...   ..    ..
C       NRC-1: real  real  real  real  real  real  ...  real  real
C       NRC:   imag  imag  imag  imag  imag  imag  ...  imag  imag
C
C       Notice that the first two rows are different from the rest.
C       The first two rows each resemble outputs of a real FFT.  Refer
C       to RFFTSC for a description of the special packed complex
C       format. Note, though, that the second row contains what would
C       have been in the NRC row, had there been room for an NRC
C       row.
C
C       Rows 2 through NRC-1 resemble outputs of a complex FFT, in
C       pairs of rows.  For example, in rows 2 and 3, the first element
C       of row 2 is the first real of the complex FFT output and the
C       first element of row 3 is the first imaginary of the complex FFT
C       output.
C
C       Refer to Appendix B for machine dependent notes.
C
C
C  REFERENCE
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RFFT2I (A,C,16,16)
C
C       Input Operands:
C
C       A =    0.125  0.0 ... for 16 columns total 0.0
C              0.125  0.0 ... for 16 columns total 0.0
C              0.125  0.0 ... for 16 columns total 0.0
C              0.0    0.0 ... for 16 columns total 0.0
C              0.125  0.0 ... for 16 columns total 0.0
C              0.0    0.0 ... for 16 columns total 0.0
C              0.125  0.0 ... for 16 columns total 0.0
C              0.0    0.0 ... for 16 columns total 0.0
C              0.125  0.0 ... for 16 columns total 0.0
C              0.0    0.0 ... for 16 columns total 0.0
C              0.125  0.0 ... for 16 columns total 0.0
C              0.0    0.0 ... for 16 columns total 0.0
C              0.125  0.0 ... for 16 columns total 0.0
C              0.0    0.0 ... for 16 columns total 0.0
C              0.125  0.0 ... for 16 columns total 0.0
C              0.0    0.0 ... for 16 columns total 0.0
C
C       Output Operands:
C
C       C =    2.0  2.0 ... for 16 columns total 2.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C              0.0  0.0 ... for 16 columns total 0.0
C
C
C  HISTORY
C         1) Feb 87     L. Shanbeck      Original.
C
      SUBROUTINE RFFT2I(A,C,NRC,NCC)
C
      REAL A(1),C(1),B
      INTEGER NRC,NCC,I,IFLG,IC
      IF (NRC.LE.0 .OR. NCC.LE.0 ) GOTO 900
      B = 0.5
      CALL VMOV(A,1,C,1,NRC*NCC)
C
C     DO INVERSE RFFT2D
C
C --- ROWS
      IC = NRC
      IFLG = -1
      CALL QTC019(C(1),NCC,IC,IFLG)
      CALL QTC019(C(2),NCC,IC,IFLG)
      DO 600 I = 3, NRC, 2
        CALL QTC018(C(I),NCC,IC,IFLG)
600   CONTINUE
C
C --- COLUMNS
      IC = 1
      DO 700 I = 1,NCC*NRC,NRC
        CALL QTC019(C(I),NRC,IC,IFLG)
700   CONTINUE
900   RETURN
      END
