C*****  RFFTB   Real-to-Complex FFT               MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RFFTB (A,C,N,IFLG)
C
C       where,
C
C       A       Real input vector.
C
C       C       Complex output vector.
C
C       N       Integer input real element count.
C
C       IFLG    Integer input processing option flag:
C                   = 1 for forward FFT
C                   =-1 for inverse FFT
C
C
C  DESCRIPTION
C
C       This routine performs the same operation as RFFT but the
C       results are stored in another vector, C, rather than in
C       the input vector A. The routine performs either a real-
C       to-complex forward or complex-to-real inverse FFT on the
C       data stored in vector A,and depending on the value of IFLG.
C
C       If IFLG = 1, the routine performs a real-to-complex forward
C       FFT.  The results are stored in vector C in a special packed
C       complex array format.  See RFFTSC for details on the packed
C       format.  These results are not properly scaled and may be
C       scaled using RFFTSC to multiply by 1/(2*N).
C
C       If IFLG = -1, the routine performs a complex-to-real inverse
C       FFT.  The results are stored in vector C and do not need
C       to be scaled.
C
C       N must be a power of two.
C
C       Refer to Appendix B for machine dependent notes.
C
C
C  REFERENCE
C
C       This code was taken from 'Programs for Digital Signal
C       Processing', by the IEEE Acoustics, Speech, and Signal
C       Processing Society.
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RFFTB (A,C,16,1)
C
C       Input Operands:
C
C       A = 1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C           1.0
C
C       Output Operands:
C
C       C = 32.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C            0.0
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE RFFTB(A,C,N,IFLG)
C
      REAL A(1),C(1)
      INTEGER N,IFLG
      IF (N.LE.1 .OR. (IFLG.NE.-1 .AND. IFLG.NE.1)) GOTO 25
      CALL VMOV(A,1,C,1,N)
      CALL RFFT(C,N,IFLG)
25    RETURN
      END
