C*****  RMESSV  Real Envelope Solve               MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMESSV (S,ICP,N,NS,BX,M)
C
C       where,
C
C       S       Real input vector of length NS.
C               S contains a superposition of the L' and D
C               factors of A.
C
C       ICP     Integer input vector of column pointers of length N+1.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       BX      Real input/output matrix of dimension N by M.  On input,
C               BX contains M right-hand sides.  On output, BX contains
C               M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C
C  DESCRIPTION
C
C       This routine solves a real linear system Ax = b,
C       where A has been factored into LDL' by RMESFC, and is
C       represented in envelope format by S and ICP.
C
C
C  REFERENCE
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RMESSV (S,ICP,5,12,BX,2)
C
C       Input Operands:
C
C       S = 0.125        ICP = 1
C           0.100              2
C           0.127              3
C           0.100              5
C           0.145              8
C          -0.013             13
C           0.100
C           0.182
C           0.000
C           0.000
C           0.000
C           0.250
C
C       BX = 8.0      -70.0
C          -45.0      -62.0
C           11.0       65.0
C           16.0      -14.0
C           24.0      -34.0
C
C
C       Output Operands:
C
C       BX = 0.0      -8.0
C           -5.0      -7.0
C            2.0       9.0
C            3.0      -1.0
C            4.0      -3.0
C
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C
      SUBROUTINE RMESSV(S,ICP,N,NS,BX,M)
C
      INTEGER M,N,NS,ICP(1)
      REAL    S(1), BX(1),SUM
      INTEGER I,J,K,K1,K2,L,II
C
      IF (N.LE.0  .OR. M.LE.0 .OR. NS.LE.0) GOTO 900
      DO 850 L = 1,M*N,N
        IF (N .GT. 1) GOTO 50
           BX(L) = BX(L) * S(ICP(1))
           GOTO 850
50      CONTINUE
C
C     FORWARD ELIMINATION
C
        II = L
        DO 220 J = 2, N
           K1 = ICP(J  ) + 1
           K2 = ICP(J+1) - 1
           II = II + 1
           IF (K1 .GT. K2) GO TO 220
           I = II
           SUM = 0.0
           DO 210 K = K1, K2
              I = I - 1
              SUM = SUM + S(K) * BX(I)
  210      CONTINUE
           BX(II) = BX(II) - SUM
  220   CONTINUE
C
C     SCALING
C
        II = L
        DO 230 I = 1, N
           BX(II) = BX(II) * S(ICP(I))
           II = II + 1
  230   CONTINUE
C
C     BACKWARD SUBSTITUTION
C
        II = L + N
        DO 250 J = N, 2, -1
           K1 = ICP(J  ) + 1
           K2 = ICP(J+1) - 1
           II = II - 1
           IF (K1 .GT. K2) GO TO 250
           I = II
           DO 240 K = K1, K2
              I = I - 1
              BX(I) = BX(I) - S(K) * BX(II)
  240      CONTINUE
  250   CONTINUE
C
850   CONTINUE
C
900   RETURN
      END
