C*****  RMMULS  Real Submatrix Multiply           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMMULS (A,NRA,B,NRB,C,NRC,NRCC,NCCC,NCAA)
C
C       where,
C
C       A       Real input matrix.
C
C       NRA     Integer input number of rows in full matrix A.
C
C       B       Real input matrix.
C
C       NRB     Integer input number of rows in full matrix B.
C
C       C       Real output matrix.
C
C       NRC     Integer input number of rows in full matrix C.
C
C       NRCC    Integer input number of rows in submatrices C
C               and A.
C
C       NCCC    Integer input number of columns in submatrices C and B.
C
C       NCAA    Integer input number of columns in submatrix A and
C               rows in submatrix B.
C
C
C  DESCRIPTION
C
C       This routine multiplies a submatrix of the full matrix A
C       by a submatrix of the full matrix B and stores the results
C       in matrix C.
C
C            C = A * B
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RMMULS (A,2,B,3,C,2,2,2,3)
C
C       Input Operands:
C
C       A =   1.0        3.0     5.0
C             2.0        4.0     6.0
C
C       B =   1.0       -2.0
C            -1.0        3.0
C             2.0       -3.0
C
C       Output Operands:
C
C       C =   8.0       -8.0
C            10.0      -10.0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C
      SUBROUTINE RMMULS(A,NRA,B,NRB,C,NRC,NRCC,NCCC,NCAA)
C
      INTEGER NRA,NRB,NRC,NRCC,NCCC,NCAA,IFLG
      REAL    A(1),B(1),C(1)
      IF (NRCC.LE.0 .OR. NCCC.LE.0 .OR. NCAA.LE.0 .OR.
     +    NRA.LT.NRCC .OR. NRB.LT.NCAA .OR. NRC.LT.NRCC) GOTO 800
C
      IFLG = 0
      CALL RMMULG(A,NRA,B,NRB,C,NRC,NRCC,NCCC,NCAA,IFLG)
800   RETURN
      END
