C*****  RMSSFS  Real Symmetric Sparse Factor and Solve     MATH ADV REL 2.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMSSFS (S,IRN,ICP,N,NS,ZTOL,BX,M,IERR)
C
C       where,
C
C       S       Real input/output vector of length NS.
C               On input, S contains the elements of the
C               real matrix A stored in sparse symmetric
C               format.  On output, S contains a superposition
C               of the L and D factors.
C
C       IRN     Integer input vector of length NS containing
C               the row number of each element stored in S.
C
C       ICP     Integer input vector of column pointers of length
C               N+1.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       BX      Real input/output matrix of dimension N by M.
C               On input, BX contains M right-hand sides.
C               On output, BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a disgonal
C                      element was less than or equal to ZTOL.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine solves the real linear system Ax = b by calling
C       RMSSFC to factor the real symmetric matrix A into LDL'
C       form.  It then calls RMSSSV to solve the system.
C
C
C  REFERENCE
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RMSSFS (S,IRN,ICP,10,22,ZTOL,BX,2,IERR)
C
C       Input Operands:
C
C       S =   4.0      IRN =   1   ICP =  1
C            13.0              2          2
C            24.0             10          4
C             5.0              3          6
C            -4.0              4         11
C            32.0              4         15
C            -2.0              5         18
C             2.0              6         20
C             3.0              7         21
C            10.0              8         22
C             4.0              5         23
C             0.0 (Fill-in)    6
C             0.0 (Fill-in)    7
C             0.0 (Fill-in)    8
C             4.0              6
C             0.0 (Fill-in)    7
C             0.0 (Fill-in)    8
C             4.0              7
C             0.0 (Fill-in)    8
C           100.0              8
C             4.0              9
C            64.0             10
C
C       BX =   0.0    16.0
C           -137.0   153.0
C             -2.0    14.0
C            133.0   122.0
C             10.0    -8.0
C            -26.0     4.0
C            -19.0    12.0
C            930.0   240.0
C             -4.0    28.0
C           -312.0   440.0
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       S = 0.250
C           0.077
C           1.846
C           0.200
C          -0.800
C           0.035
C          -0.069
C           0.069
C           0.104
C           0.347
C           0.259
C           0.036 (Fill-in)
C           0.054 (Fill-in)
C           0.180 (Fill-in)
C           0.259
C          -0.056 (Fill-in)
C          -0.187 (Fill-in)
C           0.273
C          -0.305 (Fill-in)
C           0.010
C           0.250
C           0.051
C
C       BX =   0.0     4.0
C             -5.0    -3.0
C              2.0     6.0
C              3.0     4.0
C              4.0     0.0
C             -8.0    -1.0
C             -7.0     0.0
C              9.0     2.0
C             -1.0     7.0
C             -3.0     8.0
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE RMSSFS(S,IRN,ICP,N,NS,ZTOL,BX,M,IERR)
C
      INTEGER M,N, NS, ICP(1), IRN(1), IERR
      REAL S(1), ZTOL, BX(1)
C
      IERR = 0
      IF (M.LE.0 .OR. N.LE.0 .OR. NS.LE.0) GOTO 900
      CALL RMSSFC(S,IRN,ICP,N,NS,ZTOL,IERR)
      IF(IERR .EQ. 0) CALL RMSSSV(S,IRN,ICP,N,NS,BX,M)
900   RETURN
      END
