C*****  RMSSSV  Real Symmetric Sparse Solver         MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMSSSV (S,IRN,ICP,N,NS,BX,M)
C
C       where,
C
C       S       Real input vector of length NS.  S
C               contains a superposition of the L and D
C               factors of A.
C
C       IRN     Integer input vector of length NS containing
C               the row number of each element stored in S.
C
C       ICP     Integer input vector of column pointers of length
C               N+1.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       BX      Real input/output matrix of dimension N by M.
C               On input, BX contains M right-hand sides.
C               On output, BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C
C  DESCRIPTION
C
C       This routine solves a real linear system Ax = b,
C       where A has been factored into LDL' form using RMSSFC,
C       and is represented in sparse symmetric format by S,
C       IRN, and ICP.
C
C
C  REFERENCE
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RMSSSV (S,IRN,ICP,10,22,BX,2)
C
C       Input Operands:
C
C       S = 0.250      IRN =   1   ICP =  1
C           0.077              2          2
C           1.846             10          4
C           0.200              3          6
C          -0.800              4         11
C           0.035              4         15
C          -0.069              5         18
C           0.069              6         20
C           0.104              7         21
C           0.347              8         22
C           0.259              5         23
C           0.036              6
C           0.054              7
C           0.180              8
C           0.259              6
C          -0.056              7
C          -0.187              8
C           0.273              7
C          -0.305              8
C           0.010              8
C           0.250              9
C           0.051             10
C
C       BX =   0.0    16.0
C           -137.0   153.0
C             -2.0    14.0
C            133.0   122.0
C             10.0    -8.0
C            -26.0     4.0
C            -19.0    12.0
C            930.0   240.0
C             -4.0    28.0
C           -312.0   440.0
C
C       Output Operands:
C
C       BX =   0.0     4.0
C             -5.0    -3.0
C              2.0     6.0
C              3.0     4.0
C              4.0     0.0
C             -8.0    -1.0
C             -7.0     0.0
C              9.0     2.0
C             -1.0     7.0
C             -3.0     8.0
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C
      SUBROUTINE RMSSSV(S,IRN,ICP,N,NS,BX,M)
C
      INTEGER M,N,NS,J,K,K1,K2
      REAL BX(1), S(1), TMP, SUM
      INTEGER ICP(1), IRN(1),L,LM1
      IF (N.LE.0 .OR. NS.LE.0 .OR. M.LE.0) GOTO 900
C
      DO 850 L = 1,M*N,N
      LM1 = L - 1
      K2 = 1
      IF (N.EQ.1) GOTO 21
      DO 20 J = 1, N-1
         K1 = K2 + 1
         K2 = ICP(J+1)
         IF(K1 .GE. K2) GO TO 20
         TMP = BX(J+LM1)
         IF(TMP .EQ. 0.0) GO TO 20
         DO 10 K = K1, K2-1
            BX(LM1+IRN(K)) = BX(LM1+IRN(K)) - TMP * S(K)
 10      CONTINUE
 20   CONTINUE
C
21    DO 30 J = L, LM1+N
         BX(J) = S(ICP(J-LM1)) * BX(J)
 30   CONTINUE
C
      IF (N.EQ.1) GOTO 850
      K1 = ICP(N)
      DO 50 J = N-1, 1, -1
         K2 = K1 - 1
         K1 = ICP(J)
         IF(K1 .GE. K2) GO TO 50
         SUM = BX(J+LM1)
         DO 40 K = K1+1, K2
            SUM = SUM - BX(LM1+IRN(K)) * S(K)
 40      CONTINUE
         BX(J+LM1) = SUM
 50   CONTINUE
850   CONTINUE
900   RETURN
      END
