C*****  RMSUFC  Real Sparse Factor                MATH ADVANTAGE REL 2.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMSUFC (S,IRN,ICP,IDP,N,NS,ZTOL,WRK,IERR)
C
C       where,
C
C       S       Real input/output vector of length NS.
C               On input, S contains the elements of the real
C               matrix A stored in sparse unsymmetric format.
C               On output, S contains a superposition of the L and U
C               factors of A.
C
C       IRN     Integer input vector of length NS containing
C               row number of each element stored in vector S.
C
C       ICP     Integer input vector of column pointers of length N+1.
C
C       IDP     Integer input vector of diagonal pointers of length N.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       WRK     Real workspace vector of length N.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a disgonal
C                      element was less than or equal to ZTOL.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine factors a real sparse unsymmetric matrix A
C       represented by S and ICP into LU form.
C
C       L is lower triangular and U is upper triangular.  The diagonal
C       elements of U are all 1's and are therefore not stored.  The
C       diagonal elements of L are reciprocated.
C
C       This routine does not do pivoting.  Therefore, the matrix A
C       should be numerically stable in the form in which it is input.
C
C
C  REFERENCE
C
C       C. R. Rao.  1962.  A note on a generalized inverse of a
C       matrix with application to problems in mathematical
C       statistics.  J. R. Statis. Soc., Vol. B24,  pp. 152-
C       158.
C
C       M. J. R. Healy.  1968.  Triangular decomposition of a
C       symmetric matrix.  Appl. Statis., Vol. 17,  pp. 195-
C       197.
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RMSUFC (S,IRN,ICP,IDP,10,18,ZTOL,WRK,IERR)
C
C       Input Operands:
C
C       S = 2.000      IRN =  1  ICP =  1  IDP =  1
C           16.00             2         2         2
C           2.000             5         6         6
C           3.000             6         8         8
C           3.000            10        10        10
C           2.000             3        11        11
C          -1.000             4        12        13
C           4.000             4        15        15
C           4.000             8        16        16
C           2.000             5        17        18
C           6.000             6        19
C           2.000             4
C           4.000             7
C           0.000 (Fill-in)   8
C           10.00             8
C           2.000             9
C           1.000             8
C           8.000            10
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       S = 0.500
C           0.063
C           2.000
C           3.000
C           3.000
C           0.500
C          -1.000
C           0.250
C           4.000
C           0.500
C           0.167
C           0.500
C           0.250
C          -2.000 (Fill-in)
C           0.100
C           0.500
C           0.100
C           0.125
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C         3) Dec 88     L. Tarvestad    Return correct IERR value for
C                                       cases where IERR>1.
C
      SUBROUTINE RMSUFC(S,IRN,ICP,IDP,N,NS,ZTOL,WRK,IERR)
C
      INTEGER N,NS,IERR
      REAL S(1),WRK(1),ZTOL,TMP
      INTEGER ICP(1),IRN(1),IDP(1)
      INTEGER L,J,I,K,K1,K2,L2,LD,L1
C
      IF(N.LE.0 .OR. NS.LE.0) GO TO 70
C
      L2 = ICP(2)
      DO 60 J = 1, N
         L1 = L2
         L2 = ICP(J+1)
         LD = IDP(J)
         IF(L1 .GE. LD) GO TO 56
C
         DO 20 L = L1, L2-1
            WRK(IRN(L)) = S(L)
 20      CONTINUE
C
         DO 40 L = L1, LD-1
            I = IRN(L)
            TMP = WRK(I)
            IF(TMP .EQ. 0.0) GO TO 40
            K1 = IDP(I)
            TMP = TMP * S(K1)
            WRK(I) = TMP
            K1 = K1 + 1
            K2 = ICP(I+1)
            IF(K1 .GE. K2) GO TO 40
            DO 30 K = K1, K2-1
               WRK(IRN(K)) = WRK(IRN(K)) - TMP * S(K)
 30         CONTINUE
 40      CONTINUE
C
         DO 50 L = L1, L2-1
            S(L) = WRK(IRN(L))
 50      CONTINUE
 56      TMP = S(LD)
         IF(ABS(TMP) .LE. ZTOL) GO TO 91
         S(LD) = 1.0 / TMP
C
 60   CONTINUE
C
70    IERR = 0
      GOTO 900
C
91    IERR = J
C
900   RETURN
      END
