C*****  RMSUFS  Real Sparse Factor and Solve        MATH ADVANTAGE REL 2.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RMSUFS (S,IRN,ICP,IDP,N,NS,ZTOL,BX,M,WRK,IERR)
C
C       where,
C
C       S       Real input/output vector of length NS.
C               On input, S contains the elements of the real
C               matrix A stored in sparse unsymmetric format.  On
C               output, S contains the superposition of the L and U
C               factors.
C
C       IRN     Integer input vector of length NS containing
C               the row number of each element stored in S.
C
C       ICP     Integer input vector of column pointers of length
C               N+1.
C
C       IDP     Integer input vector of diagonal pointers of length N.
C
C       N       Integer input order of matrix A.
C
C       NS      Integer input element count of vector S.
C
C       ZTOL    Real input scalar, diagonal element zero tolerance.
C
C       BX      Real input/output matrix of dimension N by M.
C               On input, BX contains M right-hand sides.
C               On output, BX contains M solution vectors.
C
C       M       Integer input number of right-hand sides.
C
C       WRK     Real workspace vector of length N.
C
C       IERR    Integer output completion code:
C                   =0 if the routine terminated normally.
C                   >0 if the routine aborted because a diagonal
C                      element was less than or equal to ZTOL.
C                      The value of IERR is the index of the column
C                      where it aborted.
C
C
C  DESCRIPTION
C
C       This routine solves the real linear system Ax = b by
C       calling RMSUFC to factor the real matrix A into LU form.
C       It then calls routine RMSUSV to solve the system.
C
C
C  REFERENCE
C
C       G. W. Stewart.  1973.  Introduction to matrix computa-
C       tions.  New York: Academic Press.
C
C
C  EXAMPLE
C
C       CALL RMSUFS (S,IRN,ICP,IDP,10,18,ZTOL,BX,2,WRK,IERR)
C
C       Input Operands:
C
C       S = 2.000      IRN =  1  ICP =  1  IDP =  1
C          16.000             2         2         2
C           2.000             5         6         6
C           3.000             6         8         8
C           3.000            10        10        10
C           2.000             3        11        11
C          -1.000             4        12        13
C           4.000             4        15        15
C           4.000             8        16        16
C           2.000             5        17        18
C           6.000             6        19
C           2.000             4
C           4.000             7
C           0.000 (Fill-in)   8
C          10.000             8
C           2.000             9
C           1.000             8
C           8.000            10
C
C       BX=  0.00    8.00
C          -80.00  -48.00
C            4.00   12.00
C           -4.00   10.00
C           -2.00   -6.00
C          -63.00  -15.00
C          -28.00    0.00
C           99.00   44.00
C           -2.00   14.00
C          -39.00   55.00
C
C       ZTOL = 1.0E-5
C
C       Output Operands:
C
C       S = 0.500
C           0.063
C           2.000
C           3.000
C           3.000
C           0.500
C          -1.000
C           0.250
C           4.000
C           0.500
C           0.167
C           0.500
C           0.250
C          -2.000 (Fill-in)
C           0.100
C           0.500
C           0.100
C           0.125
C
C       BX= 0.000   4.000
C          -5.000  -3.000
C           2.000   6.000
C           3.000   4.000
C           4.000   0.000
C          -8.000  -1.000
C          -7.000   0.000
C           9.000   2.000
C          -1.000   7.000
C          -3.000   8.000
C
C       IERR = 0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C                       R. Coleman
C         2) Jan 88     L. Shanbeck     Expanded IERR functionality
C
      SUBROUTINE RMSUFS(S,IRN,ICP,IDP,N,NS,ZTOL,BX,M,WRK,IERR)
C
      INTEGER N,NS,ICP(1),IRN(1),IDP(1),IERR,M
      REAL S(1),ZTOL,WRK(1),BX(1)
C
      IERR = 0
      IF (M.LE.0 .OR. N.LE.0 .OR. NS.LE.0) GOTO 900
      CALL RMSUFC(S,IRN,ICP,IDP,N,NS,ZTOL,WRK,IERR)
      IF(IERR .EQ. 0) CALL RMSUSV(S,IRN,ICP,IDP,N,NS,BX,M)
900   RETURN
      END
