C*****  RNDOTP  Real Nested Dot Product           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RNDOTP (A,IAI,IAO,B,IBI,IBO,C,ICO,M,N,IFLG)
C
C       where,
C
C       A       Real input vector.
C
C       IAI     Integer input stride of dot product (inner loop) for A.
C
C       IAO     Integer input stride between successive
C               dot products (outer loop) for A.
C
C       B       Real input vector.
C
C       IBI     Integer input stride of dot product (inner loop) for B.
C
C       IBO     Integer input stride between successive dot
C               products (outer loop) for B.
C
C       C       Real input/output vector.
C
C       ICO     Integer input stride between successive dot
C               product outputs (outer loop) for C.
C
C       M       Integer input number of elements in each dot product,
C               the inner loop count.
C
C       N       Integer input number of dot products to be executed,
C               the outer loop count.
C
C       IFLG    Integer input processing option flag:
C                   Option 1 (=2) to add the dot product to the input
C                             values of C.
C                   Option 2 (=1) to negate the result of dot product.
C                 The value of IFLG is additive, that is:
C                   IFLG = Option 1 + Option 2.
C                 For example, if IFLG = 3 (i.e., 2+1), RNDOTP will
C                 negate the dot product, and add the result to C.
C
C  DESCRIPTION
C
C       This routine performs a dot product using a portion of
C       vector A and a portion of vector B and stores the result
C       as an element of vector C.  It increments to the next
C       portion of A and B and repeats the operation, storing
C       the dot product in the next element of C. The operation
C       repeats N times.
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RNDOTP (A,2,1,B,1,3,C,1,3,2,1)
C
C       Input Operands:
C
C       A =   1.0     B =  1.0
C             2.0         -1.0
C             3.0          2.0
C             4.0         -2.0
C             5.0          3.0
C             6.0         -3.0
C
C       Output Operands:
C
C       C = -8.0
C           10.0
C
C  HISTORY
C         1) Nov 84     D. Cooper       Original.
C
      SUBROUTINE RNDOTP(A,IAI,IAO,B,IBI,IBO,C,ICO,M,N,IFLG)
C
      INTEGER IAI,IAO,IBI,IBO,ICO,N,M,IFLG,I,J,JA,JB,JC,IA,IB,JSW,ACM
      REAL    A(1),B(1),C(1),SUM,NEG
      IF (M.LE.0 .OR. N.LE.0 .OR. IFLG.LT.0 .OR. IFLG.GE.4) GOTO 800
C
C     THE INPUT SWITCH IFLG IS USED AS FOLLOWS:
C     BIT 0 SETS NEGATE, BIT 1 SETS ACCUMULATE
C
C     DEFAULT SWITCH VALUES:
      NEG = 1.0
      ACM = 0
C
      JSW = IFLG
C      IF (JSW.GE.4) JSW = MOD(JSW,4)
      IF (JSW.LT.2) GOTO 10
        JSW = JSW - 2
        ACM = 1
10    CONTINUE
      IF (JSW.EQ.1) NEG = -1.0
C
      JA = 1
      JB = 1
      JC = 1
      DO 220 J = 1, N
         IA  = JA
         IB  = JB
         SUM = 0.0
         DO 210 I = 1, M
            SUM = SUM + A(IA) * B(IB)
            IA  = IA + IAI
            IB  = IB + IBI
  210    CONTINUE
         IF (ACM.EQ.0) GOTO 214
           C(JC) = C(JC) + NEG * SUM
           GOTO 217
214      CONTINUE
           C(JC) = NEG * SUM
217      CONTINUE
         JA = JA + IAO
         JB = JB + IBO
         JC = JC + ICO
  220 CONTINUE
C
800   RETURN
      END
