C*****  ROTG   Construct Givens Plane Rotation       MTHADV EXT. REL 1.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL ROTG (A,B,C,S)
C
C       where,
C
C       A       Real input/output scalar.  On input, first rotational
C               elimination parameter.  On output, value R as defined
C               below.
C
C       B       Real input/output scalar.  On input, second rotational
C               elimination parameter.  On output, value Z as defined
C               below.
C
C       C       Real output scalar, cosine of angle of Givens rotation.
C
C       S       Real output scalar, sine of angle of Givens rotation.
C
C
C  DESCRIPTION
C
C       This routine constructs a Givens plane rotation using values A
C       and B.  Scaling is used to avoid overflow and destructive
C       underflow in the computation of R.
C
C       R = SIG * SQRT(A**2+B**2)  where SIG = SIGN(A) if abs(A) > abs(B)
C                                            = SIGN(B) if abs(A) <= abs(B)
C
C       Z = S    if abs(A) > abs(B)
C         = 1/C  if abs(A) <= abs(B) and C<>0.0 and R <> 0.0
C         = 1    if abs(A) <= abs(B) and C = 0.0 and R <> 0.0
C         = 0    if R = 0.0
C
C  EXAMPLE
C
C       CALL ROTG (A,B,C,S)
C
C       Input Operands:
C
C       A = 6.0    B = -8.0
C
C       Output Operands:
C
C       A = -10.0  B = -1.67  C = -0.6  S = 0.8
C
C
C  HISTORY
C         1) Dec 86     L. Tarvestad    Original (LINPAK SROTG).
C                                       Define A=B=0.0 when R=0.0
C
C-----------------------------------------------------------------------
C
      SUBROUTINE ROTG(A,B,C,S)
C
      REAL A,B,C,S,ROE,SCALE,R,Z
C
C-----------------------------------------------------------------------
C
      ROE = B
      IF (ABS(A) .GT. ABS(B)) ROE = A
      SCALE = ABS(A) + ABS(B)
      IF (SCALE .NE. 0.0) GO TO 10
        C = 1.0
        S = 0.0
        A = 0.0
        B = 0.0
        GO TO 30
10    R = SCALE * SQRT((A/SCALE)**2 + (B/SCALE)**2)
      R = SIGN(1.0,ROE) * R
      C = A/R
      S = B/R
      Z = 1.0
      IF (ABS(A) .GT. ABS(B)) Z = S
      IF (ABS(B) .GE. ABS(A) .AND. C .NE. 0.0) Z = 1.0/C
      A = R
      B = Z
30    RETURN
      END
