C*****  SASUM    Sum of Magnitudes of Single Prec Reals     MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       SW = SASUM (N,SX,INCX)
C
C       where,
C
C       N       Integer input element count.
C
C       SX      Real input vector.
C
C       INCX    Integer input stride for vector SX.
C               May not be negative.
C
C
C  DESCRIPTION
C
C       This function returns the sum of the absolute values of the
C       elements of vector SX.
C
C               SASUM = sum (ABS(SX(i))       for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       SW = SASUM (5,SX,1)
C
C       Input Operands:
C
C       SX =  1.000
C             2.000
C            -3.000
C             4.000
C             5.000
C
C       Output Result:
C
C       SW = 15.0
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      REAL FUNCTION SASUM(N,SX,INCX)
      REAL SX(1)
      INTEGER N,INCX,I,NS
C
      SASUM = 0.0
      IF(N.LE.0 .OR. INCX.LT.0) GO TO 999
C
      NS = N*INCX
      DO 10 I = 1,NS,INCX
        SASUM = SASUM + ABS(SX(I))
   10 CONTINUE
999   RETURN
      END
