C*****  SAXPY  Real Scalar Times a Vector Plus a Vector    MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL SAXPY (N,SA,SX,INCX,SY,INCY)
C
C       where,
C
C       N       Integer input element count.
C
C       SA      Real input scalar.
C
C       SX      Real input vector.
C
C       INCX    Integer input stride for vector SX.
C
C       SY      Real input/output vector.
C
C       INCY    Integer input stride for vector SY.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of a real vector SX
C       by a real scalar SA and adds the elements of another
C       real vector SY.  The results are stored back in real
C       vector SY.
C
C       SY(i) = (SA * SX(i)) + SY(i)      for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       CALL SAXPY (2,SA,SX,1,SY,1)
C
C       Input Operands:
C
C       SA =  2.000
C
C       SX =  1.000
C             3.000
C
C       SY =  10.000
C             30.000
C
C       Output Operands:
C
C       SY =  12.000
C             36.000
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      SUBROUTINE SAXPY(N,SA,SX,INCX,SY,INCY)
C
      REAL SA,SX(1),SY(1)
      INTEGER N,INCX,INCY,II,KK,M
      IF (N.LE.0 .OR. SA.EQ.0.0) GO TO 40
      II = 1
      KK = 1
      IF (INCX.LT.0) II = (-N+1)*INCX + 1
      IF (INCY.LT.0) KK = (-N+1)*INCY + 1
      DO 10 M=1,N
        SY(KK) = SA*SX(II) + SY(KK)
        II = II+INCX
        KK = KK+INCY
10    CONTINUE
40    RETURN
      END
