C*****  SPLBIN  Bicubic Spline Interpolation     MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL SPLBIN(A,IA,B,IB,C,D,WRK,WRK1,WRK2,E,F,G,M,N)
C
C       where,
C
C       A       Real input vector of length M.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector of length N.
C
C       IB      Integer input stride for vector B.
C
C       C       Real input matrix containing tabulated function
C               values at points (A(i),B(i)).
C
C       D       Real input matrix containing second derivatives
C               of one-dimensional natural cubic splines of the
C               rows of array C, calculated by SPLBAP.
C
C       WRK     Real workspace vector of length N.
C
C       WRK1    Real workspace vector of length M.
C
C       WRK2    Real workspace vector of length M.
C
C       E       Real input scalar in A domain at which to find
C               interpolated value.
C
C       F       Real input scalar in B domain at which to find
C               interpolated value.
C
C       G       Real output scalar, interpolated value at point (E,F).
C
C       M       Integer input element count for vector A.
C
C       N       Integer input element count for vector B.
C
C
C  DESCRIPTION
C
C       This routine calculates an interpolated value of a function.
C       The function values are defined at points (A(i),B(i)); the
C       value of the function at each point (A(i),B(i)) is given in
C       C(i,j).  The interpolated value at the point (E,F) is
C       calculated by a bicubic spline technique, using a table of
C       second derivatives of the rows of the function, denoted D, (D
C       is calculated by SPLBAP).  The routine uses the table of second
C       derivatives to create a temporary vector of interpolated points
C       then calculates a table of second derivatives of the inter-
C       polated column then interpolates for the row value. The values
C       of the elements in arrays A and B are assumed to be monoton-
C       ically increasing and the values of E and F must satisfy the
C       relationships A(1) <= E <= A(M) and B(1) <= F <= B(N).  For
C       a further explanation of how the values are interpolated see
C       documentation for SPLCAP.
C
C
C  REFERENCES
C
C       J.H. Ahlberg, E.N. Nilson and J.L. Walsh. 1976. The Theory
C       of Splines and Their Applications. New York: Academic Press.
C
C       T.N.E. Greville. 1969. Introduction To Spline Functions. In
C       Theory and Applications of Spline Functions. New York: Academic
C       Press.
C
C
C  EXAMPLE
C                           2   2
C       Using function C = A + B
C
C       CALL SPLBIN(A,1,B,1,C,D,WRK,WRK1,WRK2,E,F,G,10,10)
C
C       Input Operands:
C
C       A = 0.00
C           1.00
C           2.00
C           3.00
C           4.00
C           5.00
C           6.00
C           7.00
C           8.00
C           9.00
C
C       B = 0.00
C           1.00
C           2.00
C           3.00
C           4.00
C           5.00
C           6.00
C           7.00
C           8.00
C           9.00
C
C       C = 0.    1.    4.    9.    16.   25.   36.   49.   64.   81.
C           1.    2.    5.    10.   17.   26.   37.   50.   65.   82.
C           4.    5.    8.    13.   20.   29.   40.   53.   68.   85.
C           9.    10.   13.   18.   25.   34.   45.   58.   73.   90.
C           16.   17.   20.   25.   32.   41.   52.   65.   80.   97.
C           25.   26.   29.   34.   41.   50.   61.   74.   89.   106.
C           36.   37.   40.   45.   52.   61.   72.   85.   100.  117.
C           49.   50.   53.   58.   65.   74.   85.   98.   113.  130.
C           64.   65.   68.   73.   80.   89.   100.  113.  128.  145.
C           81.   82.   85.   90.   97.   106.  117.  130.  145.  162.
C
C       D = 2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0
C           2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0
C           2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0
C           2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0
C           2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0
C           2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0
C           2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0
C           2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0
C           2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0
C           2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0  2.0
C
C       E = 7.5
C
C       F = 8.5
C
C       Output Operands:
C
C       G = 128.475
C
C
C  HISTORY
C         1) Dec 87     C. Ward           Original.
C
      SUBROUTINE SPLBIN(A,IA,B,IB,C,D,WRK,WRK1,WRK2,E,F,G,M,N)
C
      INTEGER IA,IB,J,M,N
      REAL A(1),B(1),WRK(1),WRK1(1),WRK2(1),E,F,G
      REAL C(M,N),D(M,N)
      REAL EPS,TINY,HUGE
      DATA EPS,TINY,HUGE/0.0,0.0,0.0/
      IF ( N.LE.0 ) GO TO 999
C
      IF (HUGE.EQ.0.0) THEN
         CALL QTC045(EPS,TINY,HUGE)
      ENDIF
C
      DO 12 J = 1,M
         CALL SPLCIN(B,IB,C(J,1),M,D(J,1),N,F,WRK(J),N)
  12  CONTINUE
      CALL SPLCAP(A,IA,WRK,1,HUGE,HUGE,WRK1,WRK2,1,M)
      CALL SPLCIN(A,IA,WRK,1,WRK2,1,E,G,M)
  999 CONTINUE
      RETURN
      END
