C*****  SROT    Apply a Plane Rotation                   MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL SROT (N,SX,INCX,SY,INCY,SC,SS)
C
C       where,
C
C       N       Integer input element count for vectors SX and SY.
C
C       SX      Real input/output vector of length N.
C
C       INCX    Integer input stride for vector SX.
C
C       SY      Real input/output vector of length N.
C
C       INCY    Integer input stride for vector SY.
C
C       SC      Real value of diagonal elements of 2 by 2 matrix.
C
C       SS      Real value of non-diagonal elements of 2 by 2 matrix.
C
C
C  DESCRIPTION
C
C       This routine computes a plane rotation of the form
C
C              |SX(i)|      | SC  SS|   |SX(i)|
C              |SY(i)|  =   |-SS  SC|   |SY(i)|    for i=1,N
C
C       If N<=0, or if SC=1.0 and SS=0.0 then the routine returns
C       immediately.
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       CALL SROT (5,SX,1,SY,1,SC,SS)
C
C       Input Operands:
C
C       SX =  1.000
C             2.000
C             3.000
C             4.000
C             5.000
C
C       SY = -2.000
C            -1.000
C             0.000
C             1.000
C             2.000
C
C       SC =  2.000
C
C       SS =  5.000
C
C       Output Operands:
C
C       SX = -8.000
C            -1.000
C             6.000
C            13.000
C            20.000
C
C       SY = -9.000
C           -12.000
C           -15.000
C           -18.000
C           -21.000
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      SUBROUTINE SROT (N,SX,INCX,SY,INCY,SC,SS)
C
      REAL SX(1),SY(1),SC,SS,STEMP
      INTEGER N,INCX,INCY,IX,IY,I
C
      IF (N.LE.0 .OR. (SC.EQ.1.0 .AND. SS.EQ.0.0)) GO TO 999
C
      IX = 1
      IY = 1
      IF (INCX.LT.0) IX = (1-N)*INCX + 1
      IF (INCY.LT.0) IY = (1-N)*INCY + 1
      DO 10 I = 1,N
        STEMP  = SC*SX(IX) + SS*SY(IY)
        SY(IY) = SC*SY(IY) - SS*SX(IX)
        SX(IX) = STEMP
        IX = IX + INCX
        IY = IY + INCY
   10 CONTINUE
  999 RETURN
      END
