C*****  SROTMG   Construct Modified Givens Plane Transform   MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL SROTMG (SD1,SD2,SX1,SY1,S)
C
C       where,
C
C       SD1     Real input/output scalar.  Should be nonnegative.
C
C       SD2     Real input/output scalar.  Can be negative for the
C               purpose of removing data from a least squares problem.
C
C       SX1     Real input/output scalar.
C
C       SY1     Real input scalar.
C
C       S       Real output vector of length 5.
C               S(1) = Flag indicating 2 by 2 matrix format as below.
C               S(2) = value of 2 by 2 matrix element (1,1)
C               S(3) = value of 2 by 2 matrix element (2,1)
C               S(4) = value of 2 by 2 matrix element (1,2)
C               S(5) = value of 2 by 2 matrix element (2,2)
C
C  DESCRIPTION
C
C       The input quantities SD1, SD2, SX1, SY1 define a 2-vector
C       |a1, a2|Transpose in partitioned form as
C
C               |a1|    |SQRT(SD1)    0.0   |.|SX1|
C               |a2| =  |   0.0    SQRT(SD2)| |SY1|
C
C       This routine constructs a 2 by 2 modified Givens rotation
C       matrix that transforms SY1, and thus a2, to zero.
C
C       The constructed matrix is of the form:
C
C                      |S(2)  S(4)|
C                      |S(3)  S(5)|
C
C       where the 2 by 2 matrix is constructed to satisfy one of the
C       following sets of flag and matrix values:
C         S(1)=-1.0        S(1)=0.0        S(1)=1.0      S(1)=-2.0
C       |S(2)  S(4)|     |1.0  S(4)|     |S(2)  1.0|     |1.0  0.0|
C       |S(3)  S(5)|     |S(3)  1.0|     |-1.0 S(5)|     |0.0  1.0|
C
C       NOTE: Matrix values of 0.0, 1.0 or -1.0 as specified in the
C       diagram above are not stored in output vector S.
C
C       The values of SD1, SD2, SX1 are changed to represent the
C       effect of the transformation.  The value of SY1 which would be
C       zeroed by the transformation is left unchanged.
C
C
C  REFERENCE
C
C       C.L. Lawson and R.J. Hanson, D.R. Kincaid, F.T. Krogh.
C       September, 1979.  Basic Linear Algebra Subprograms for Fortran Usage.
C       ACM Trans. Math. Software, Vol 5, Number 3
C
C
C  EXAMPLE
C
C       CALL SROTMG (SD1,SD2,SX1,SY1,S)
C
C       Input Operands:
C
C       SD1 =   1.000
C
C       SD2 =   2.000
C
C       SX1 =  -3.000
C
C       SY1 =   5.000
C
C       Output Operands:
C
C       SD1 =   1.695
C
C       SD2 =   0.847
C
C       SX1 =   5.900
C
C       S   =   1.000
C              -0.300
C               0.000
C               0.000
C              -0.600
C
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C         2) Jan 88     W.R. Smith      Modified to simplify code.
C                                       No change to functionality.
C
      SUBROUTINE SROTMG(SD1,SD2,SX1,SY1,S)
      REAL SD1,SD2,SX1,SY1,S(5)
      REAL SFLAG,SP1,SP2,SQ1,SQ2,SH11,SH12,SH21,SH22,STEMP,SU
      DATA ZERO,ONE,TWO/0.0,1.0,2.0/
      DATA GAM,GAMSQ,RGAMSQ/4096.0,1.67772E7,5.96046E-8/
C
C * * * * * * * *
C
C   CHECK FOR THE ABNORMAL CASES FIRST
C
C   CHECK SD1 .LT. 0.0             ZERO H,D AND SX1
C   CHECK SD2 OR SY1 .EQ. 0.0      SFLAG = -2.0
C
C * * * * * * * *
C
      IF (SD1 .LT. ZERO) GO TO 800
C
      IF (SD2 .EQ. ZERO .OR. SY1 .EQ. ZERO) THEN
          SFLAG = -TWO
          GO TO 9999
          ENDIF
C
C * * * * * * * *
C
C   THE REGULAR CASES
C
C * * * * * * * *
C
      SP2 = SD2*SY1
      SP1 = SD1*SX1
      SQ2 = SP2*SY1
      SQ1 = SP1*SX1
C
      IF (ABS(SQ1) .LE. ABS(SQ2)) GO TO 40
C
C   HERE IF   ABS(SQ1) .GT. ABS(SQ2)
C
         SH21 = -SY1/SX1
         SH12 = SP2/SP1
         SU   = ONE-SH12*SH21
C
C   IF SU .LE. ZERO        GO ZERO H,D AND SX1
         IF (SU .LE. ZERO) GO TO 800
C
            SFLAG = ZERO
            SD1 = SD1/SU
            SD2 = SD2/SU
            SX1 = SX1*SU
C
C   GO SCALE-CHECK..
            GO TO 100
C
C
C   HERE IF   ABS(SQ1) .LE. ABS(SQ2)
C   CHECK   SQ2 .LT. ZERO         GO ZERO H,D AND SX1
C
40    IF (SQ2 .LT. ZERO) GO TO 800
C
         SFLAG = ONE
         SH11 = SP1/SP2
         SH22 = SX1/SY1
         SU   = ONE+SH11*SH22
         STEMP = SD2/SU
         SD2  = SD1/SU
         SD1  = STEMP
         SX1  = SY1*SU
C   GO SCALE-CHECK
         GO TO 100
C
C * * * * * * * *
C
C   SCALE CHECK
C   FIRST CHECK IF SCALING IS NEEDED AT ALL BEFORE PLUNGING INTO
C   THE INDIVIDUAL SCALING CHECKS
C
C   IN GENERAL, CHECK BOTH SD1 AND ABS(SD2) TO BE BETWEEN
C   RGAMSQ (A SMALL NUMBER) AND GAMSQ (A LARGE NUMBER).
C   IF THEY ARE BETWEEN, IT'S OK.
C   IF NOT BETWEEN, SET SFLAG = -1.0 TO INDICATE SCALING AND ADJUST'EM.
C
C   IF SD1 OR SD2 .EQ. 0.0 THAT'S SPECIAL CASE AND NO SCALING DONE.
C
C * * * * * * * *
C
100   IF (SD1 .EQ. ZERO) GO TO 102
         IF (SD1 .LT. RGAMSQ  .OR.
     1       SD1 .GT. GAMSQ)   GO TO 108
C
102   IF (SD2 .EQ. ZERO) GO TO 220
         IF (ABS(SD2) .LT. RGAMSQ  .OR.
     1       ABS(SD2) .GT. GAMSQ)   GO TO 108
C
      GO TO 220
C
C * * * * * * * *
C
C   SCALING REQUIRED, SET FLAG AND GET INTO SCALING LOOPS
C   FIX-H..
C
C * * * * * * * *
C
108   IF (SFLAG .EQ. ZERO) THEN
         SH11 = ONE
         SH22 = ONE
         ENDIF
      IF (SFLAG .GT. ZERO) THEN
         SH21 = -ONE
         SH12 = ONE
         ENDIF
      SFLAG = -ONE
C
C   SCALE SD1
C
110   CONTINUE
      IF (SD1 .GT. RGAMSQ) GO TO 140
         IF(SD1 .EQ. ZERO) GO TO 170
C
         SD1=SD1*GAM**2
         SX1=SX1/GAM
         SH11=SH11/GAM
         SH12=SH12/GAM
         GO TO 110
C
140   CONTINUE
      IF (SD1 .LT. GAMSQ) GO TO 170
C
         SD1=SD1/GAM**2
         SX1=SX1*GAM
         SH11=SH11*GAM
         SH12=SH12*GAM
         GO TO 140
C
C   SCALE SD2
C
170   CONTINUE
      IF (ABS(SD2) .GT. RGAMSQ) GO TO 200
         IF (SD2 .EQ. ZERO) GO TO 220
C
         SD2=SD2*GAM**2
         SH21=SH21/GAM
         SH22=SH22/GAM
         GO TO 170
C
200   CONTINUE
      IF (ABS(SD2) .LT. GAMSQ) GO TO 220
C
         SD2=SD2/GAM**2
         SH21=SH21*GAM
         SH22=SH22*GAM
         GO TO 200
C
C * * * * * * * *
C
C   SET RETURN VALUES AND EXIT
C
C * * * * * * * *
C
220   CONTINUE
      IF (SFLAG .EQ. ZERO) THEN
         S(3)=SH21
         S(4)=SH12
         ENDIF
C
      IF (SFLAG .GT. ZERO) THEN
         S(2)=SH11
         S(5)=SH22
         ENDIF
C
      IF (SFLAG .LT. ZERO) THEN
         S(2)=SH11
         S(3)=SH21
         S(4)=SH12
         S(5)=SH22
         ENDIF
C
      GO TO 9999
C
C * * * * * * * *
C
C     ZERO H,D AND SX1
C
C * * * * * * * *
C
800   SFLAG = -ONE
      S(2) = ZERO
      S(3) = ZERO
      S(4) = ZERO
      S(5) = ZERO
      SD1  = ZERO
      SD2  = ZERO
      SX1  = ZERO
      GO TO 9999
C
C  SET FLAG AND EXIT
C
9999  S(1)=SFLAG
      RETURN
C
      END
