C*****  VABS    Vector Absolute Value             MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VABS (A,IA,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine computes the absolute value of the elements
C       of the vector A and stores the results in C.
C
C            C(i) = ABS(A(i))    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VABS (A,1,C,1,5)
C
C       Input Operands:
C
C       A = -1.00
C            2.00
C            3.00
C            4.00
C           -5.00
C
C       Output Operands:
C
C       C = 1.00
C           2.00
C           3.00
C           4.00
C           5.00
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VABS(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL C(1),A(1)
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      DO 10 M=1,N
        C(KK) = ABS(A(II))
        II = II + IA
        KK = KK + IC
10    CONTINUE
12    RETURN
      END
