C*****  VASM    Vector Add and Scalar Multiply    MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VASM (A,IA,B,IB,C,D,ID,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real input scalar value.
C
C       D       Real output vector.
C
C       ID      Integer input stride for vector D.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine adds the elements of two vectors, A and B,
C       multiplies the sum by a scalar C, and stores the results
C       in vector D.
C
C            D(i) = (A(i) + B(i)) * C    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VASM (A,1,B,1,C,D,1,5)
C
C       Input Operands:
C
C       A = 1.00       B = 0.10
C           2.00           0.20
C           3.00           0.30
C           4.00           0.40
C           5.00           0.50
C
C       C = 2.0
C
C       Output Operands:
C
C       D = 2.20
C           4.40
C           6.60
C           8.80
C           11.0
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VASM(A,IA,B,IB,C,D,ID,N)
C
      INTEGER IA,IB,ID,N,II,JJ,LL,M
      REAL A(1),B(1),C,D(1)
      IF (N.LE.0) GO TO 12
      II = 1
      JJ = 1
      LL = 1
      DO 10 M=1,N
        D(LL) = (A(II) + B(JJ)) * C
        II = II+IA
        JJ = JJ+IB
        LL = LL+ID
10    CONTINUE
12    RETURN
      END
