C*****  VDIVZ   Vector Divide with Zero Test            MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VDIVZ (A,IA,B,IB,C,D,ID,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real input scalar.
C
C       D       Real output vector.
C
C       ID      Integer input stride for vector D.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine divides the elements of a vector A by
C       the corresponding non-zero elements of a vector B
C       and stores the results in vector D.  Elements of
C       vector D corresponding to zero elements of vector
C       B are set equal to C.
C
C         D(i) = A(i) / B(i)  if B(i) <> 0.0
C         D(i) = C            if B(i) = 0.0  for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VDIVZ (A,1,B,1,C,D,1,5)
C
C       Input Operands:
C
C       A = 1.0     B = 0.50     C = 3.33
C           2.0         0.40
C           3.0         0.30
C           4.0         0.00
C           5.0         0.10
C
C       Output Operands:
C
C       D = 2.00
C           5.00
C          10.00
C           3.33
C          50.00
C
C  HISTORY
C         1) Jul 86     D. Benua      Original.
C
      SUBROUTINE VDIVZ(A,IA,B,IB,C,D,ID,N)
C
      INTEGER IA,IB,ID,N,II,JJ,KK,M
      REAL A(1),B(1),C,D(1)
      IF (N.LE.0) GO TO 22
      II = 1
      JJ = 1
      KK = 1
      DO 20 M=1,N
        IF (B(JJ) .EQ. 0.0) GOTO 10
        D(KK) = A(II) / B(JJ)
        GOTO 12
10      D(KK) = C
12      II = II+IA
        JJ = JJ+IB
        KK = KK+ID
20    CONTINUE
22    RETURN
      END
