C*****  VIFIX   Vector Fix to Integer             MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VIFIX (A,IA,C,IC,N,IFLG)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Integer output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C       IFLG    Integer input processing option flag:
C                   =0 for round on fix.
C                   =1 for truncate on fix.
C
C
C  DESCRIPTION
C
C       This routine changes the elements of a vector A from type real
C       to type integer data, storing the results in C.
C
C       If IFLG = 0, the fractional parts of the real values are
C       rounded.
C
C            C(i) = FIX(A(i)+0.5)    for i=1,N
C
C       If IFLG = 1, the fractional parts of the real values are
C       truncated.
C
C            C(i) = FIX(A(i))    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VIFIX (A,1,C,1,5,0)
C
C       Input Operands:
C
C       A = 0.500
C          -0.500
C           1.200
C           3.600
C          -1.400
C
C       Output Operands:
C
C       C = 1
C          -1
C           1
C           4
C          -1
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VIFIX(A,IA,C,IC,N,IFLG)
C
      INTEGER IA,IC,N,IFLG,C(1),II,KK,M
      REAL A(1),HALF
      IF (N.LE.0 .OR. IFLG.LT.0 .OR. IFLG.GT.1) GO TO 12
      II = 1
      KK = 1
      DO 10 M=1,N
        IF (IFLG.NE.0) GOTO 6
          HALF  = SIGN(0.5,A(II))
          C(KK) = IFIX(A(II)+HALF)
          GOTO 8
6         C(KK) = IFIX(A(II))
8       II = II + IA
        KK = KK + IC
10    CONTINUE
12    RETURN
      END
