C*****  VIFIX2  Floating Pt. to Integer*2 Conversion MTHADV EXT. REL 1.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VIFIX2 (A,IA,C,IC,N,IFLG)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Integer*2 output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C       IFLG    Integer input processing option flag:
C                   =0 for round on fix.
C                   =1 for truncate on fix.
C
C
C  DESCRIPTION
C
C       This routine changes the elements of a vector A from type real
C       to type integer*2 data, storing the results in C.
C
C       If IFLG = 0, the fractional parts of the real values are
C       rounded.
C
C            C(i) = INT(A(i)+0.5), if A(i) >= 0.0
C            C(i) = INT(A(i)-0.5), if A(i) <  0.0   for i=1,N
C
C       If IFLG = 1, the fractional parts of the real values are
C       truncated.
C
C            C(i) = INT(A(i))    for i=1,N
C
C       This routine is identical to VIFIX, except that the output
C       vector C is of type INTEGER*2 instead of INTEGER*4.
C
C       Note: this routine is available only on the IBM 3090.
C
C  EXAMPLE
C
C       CALL VIFIX2 (A,1,C,1,5,0)
C
C       Input Operands:
C
C       A = 0.500
C          -0.500
C           1.200
C           3.600
C          -1.400
C
C       Output Operands:
C
C       C = 1
C          -1
C           1
C           4
C          -1
C
C  HISTORY
C         1) Dec 86     L. Tarvestad    Original.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE VIFIX2(A,IA,C,IC,N,IFLG)
C
      INTEGER IA,IC,N,IFLG,II,KK,M
      INTEGER*2 C(1)
      REAL A(1)
C
C-----------------------------------------------------------------------
C
      IF (N.LE.0 .OR. IFLG.LT.0 .OR. IFLG.GT.1) GO TO 30
      II = 1
      KK = 1
      IF (IFLG.NE.0) GO TO 20
C
C HERE FOR ROUNDING.
      DO 12 M=1,N
        IF (A(II).GE.0.0D0) THEN
          C(KK) = A(II)+0.5D0
        ELSE
          C(KK) = A(II)-0.5D0
        END IF
        II = II + IA
        KK = KK + IC
12    CONTINUE
      GO TO 30
C
C HERE FOR TRUNCATION.
20    DO 22 M=1,N
        C(KK) = A(II)
        II = II + IA
        KK = KK + IC
22    CONTINUE
C
30    RETURN
      END
