C*****  VLOGZ    Vector Logarithm with Zero Test    MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VLOGZ (A,IA,B,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input scalar.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine takes the natural logarithm of the elements of a
C       vector A that are greater than zero, and stores the results
C       in vector C.  Elements of C corresponding to values of A
C       less than or equal to zero are set to the value of B.
C
C            C(i) = LOG(A(i))   if A(i) > 0.0
C            C(i) = B           if A(i) <= 0.0      for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VLOGZ (A,1,B,C,1,4)
C
C       Input Operands:
C
C       A = 1.000     B = 55.55
C           7.389
C          20.090
C          54.600
C
C       Output Operands:
C
C       C = 0.00
C           2.00
C           3.00
C           4.00
C
C  HISTORY
C         1) Jul 86     D. Benua       Original.
C
      SUBROUTINE VLOGZ(A,IA,B,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL C(1),A(1),B
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      DO 10 M=1,N
        IF (A(II) .LE. 0.0) GOTO 6
            C(KK) = ALOG(A(II))
            GOTO 8
6       C(KK) = B
8       II = II + IA
        KK = KK + IC
10    CONTINUE
12    RETURN
      END
