C*****  VPYTHG   Vector Pythagoras   MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VPYTHG (A,IA,B,IB,C,IC,D,ID,E,IE,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Real input vector.
C
C       IC      Integer input stride for vector C.
C
C       D       Real input vector.
C
C       ID      Integer input stride for vector D.
C
C       E       Real output vector.
C
C       IE      Integer input stride for vector E.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine computes the square root of the sum of the
C       squares of the differences of vectors A and C, and
C       vectors B and D, storing the results in vector E.
C
C          E(i) = SQRT( (A(i) - C(i))**2 +  (B(i) - D(i))**2 )
C                 for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VPYTHG (A,1,B,1,C,1,D,1,E,1,5)
C
C       Input Operands:
C
C       A = 5.00    B = 0.50     C = 2.0     D = 0.20
C           4.00        0.40         3.0         0.30
C           3.00        0.30         4.0         0.40
C           2.00        0.20         5.0         0.50
C           1.00        0.10         6.0         0.60
C
C       Output Operands:
C
C       E = 3.015
C           1.005
C           1.005
C           3.015
C           5.025
C
C  HISTORY
C         1) Jul 86     D. Benua      Original.
C
      SUBROUTINE VPYTHG(A,IA,B,IB,C,IC,D,ID,E,IE,N)
C
      INTEGER IA,IB,IC,ID,IE,N,II,JJ,KK,LL,TT,M
      REAL A(1),B(1),C(1),D(1),E(1)
      IF (N.LE.0) GO TO 12
      II = 1
      JJ = 1
      KK = 1
      LL = 1
      TT = 1
      DO 10 M=1,N
        E(TT) = SQRT( (A(II) - C(KK))**2 + (B(JJ) - D(LL))**2 )
        II = II+IA
        JJ = JJ+IB
        KK = KK+IC
        LL = LL+ID
        TT = TT+IE
10    CONTINUE
12    RETURN
      END
