C*****  VRAMP   Vector Ramp                       MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C
C  CALL FORMAT
C
C       CALL VRAMP (A,B,C,IC,N)
C
C       where,
C
C       A       Real input scalar, initial ramp value.
C
C       B       Real input scalar, ramp increment.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine fills the elements of a vector C with a
C       ramp specified by scalars A and B.
C
C            C(i) = A + ((i-1) * B)    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VRAMP (A,B,C,1,5)
C
C       Input Operands:
C
C       A = 1.00       B = 0.25
C
C       Output Operands:
C
C       C = 1.00
C           1.25
C           1.50
C           1.75
C           2.00
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VRAMP(A,B,C,IC,N)
C
      INTEGER IC,N,KK,M
      REAL A,B,C(1)
      IF (N.LE.0) GO TO 12
      KK = 1
      DO 10 M=1,N
       C(KK) = A + (M-1)*B
       KK = KK + IC
10    CONTINUE
12    RETURN
      END
