C*****  VRVRS   Vector Reverse Ordering           MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VRVRS (C,IC,N)
C
C       where,
C
C       C       Real input/output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine reverses the order of the elements in
C       a vector C.
C
C            C(i) = C(N-i+1)
C            C(N-i+1) = C(i)    for i=1,N/2
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VRVRS (C,1,5)
C
C       Input Operands:
C
C       C = 1.00
C           2.00
C           3.00
C           4.00
C           5.00
C
C       Output Operands:
C
C       C = 5.00
C           4.00
C           3.00
C           2.00
C           1.00
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VRVRS(C,IC,N)
C
      INTEGER IC,N,KK,KK2,N2,M
      REAL C(1),SWAP
      IF (N.LE.1) GO TO 12
      KK = 1
      KK2 = (N-1) * IC + 1
      N2 = (N/2)
      DO 10 M=1,N2
        SWAP = C(KK)
        C(KK) = C(KK2)
        C(KK2)= SWAP
        KK = KK + IC
        KK2 = KK2 - IC
10    CONTINUE
12    RETURN
      END
