C*****  VSDIV    Vector Scalar Divide             MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VSDIV (A,IA,B,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input scalar.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine divides the elements of vector A by the
C       scalar B and stores the results in vector C.
C
C            C(i) = A(i) / B    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VSDIV (A,1,B,C,1,5)
C
C       Input Operands:
C
C       A = 1.00     B = 0.5
C          -2.00
C           3.00
C           4.00
C          -5.00
C
C
C       Output Operands:
C
C       C = 2.00
C          -4.00
C           6.00
C           8.00
C          -10.0
C
C  HISTORY
C         1) Aug 86     D. Benua       Original.
C
C
      SUBROUTINE VSDIV(A,IA,B,C,IC,N)
C
      INTEGER IA,IC,N
      REAL A(1),B,C(1),BINV
      IF (N.LE.0) GO TO 12
      BINV = 1.0 / B
      CALL VSMUL(A,IA,BINV,C,IC,N)
12    RETURN
      END
