C*****  VSIMPS  Vector Simpson's Rule Integrate   MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VSIMPS (A,IA,C,IC,N,H)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C       H       Real input scalar, integration step size.
C
C
C  DESCRIPTION
C
C       This routine integrates a vector by using Simpson's rule.
C
C            C(1) = 0.0
C            C(2) = [A(1)+A(2)]*H/2
C            C(i) = C(i-2) + [A(i-2)+4.0*A(i-1)+A(i)]*H/3
C            for i=3,N
C
C
C  REFERENCE
C
C       R. Beckett and J. Hurt.  1967.  Numerical calculations
C       and algorithms.  New York: McGraw-Hill.
C
C
C  EXAMPLE
C
C       CALL VSIMPS (A,1,C,1,5,H)
C
C       Input Operands:
C
C       A = 1.000
C           2.000
C           1.000
C           3.000
C           5.000
C
C       H = 0.500
C
C       Output Operands:
C
C       C = 0.000
C           0.750
C           1.667
C           2.250
C           4.667
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VSIMPS(A,IA,C,IC,N,H)
C
      INTEGER IA,IC,N,II,KK,M,K2
      REAL A(1),C(1),H,X,Y,Z,HOV3
      IF (N.LE.0) GO TO 12
      X = A(1)
      C(1) = 0.0
      IF (N.LE.1) GO TO 12
      II = 1 + IA
      KK = 1 + IC
      Y = X
      X = A(II)
      C(KK) = 0.5*H*(X+Y)
      IF (N.LE.2) GO TO 12
      HOV3 = H/3.0
      K2 = IC+IC
      DO 10 M=3,N
        II = II+IA
        KK = KK+IC
        Z = Y
        Y = X
        X = A(II)
        C(KK) = C(KK-K2) + HOV3*(Z + 4.0*Y + X)
10    CONTINUE
12    RETURN
      END
