C*****  VSMSA   Vector Scalar Multiply and Scalar Add    MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VSMSA (A,IA,B,C,D,ID,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input scalar.
C
C       C       Real input scalar.
C
C       D       Real output vector.
C
C       ID      Integer input stride for vector D.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of a vector A by a
C       scalar B, and adds a second scalar C to the product.
C       The results are stored in D.
C
C            D(i) = (A(i) * B) + C    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VSMSA (A,1,B,C,D,1,5)
C
C       Input Operands:
C
C       A = 1.00
C           2.00
C           3.00
C           4.00
C           5.00
C
C       B = 2.00
C
C       C =-1.00
C
C       Output Operands:
C
C       D = 1.00
C           3.00
C           5.00
C           7.00
C           9.00
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VSMSA(A,IA,B,C,D,ID,N)
C
      INTEGER IA,ID,N,II,LL,M
      REAL A(1),B,C,D(1)
      IF (N.LE.0) GO TO 12
      II = 1
      LL = 1
      DO 10 M=1,N
        D(LL) = A(II) * B + C
        II = II+IA
        LL = LL+ID
10    CONTINUE
12    RETURN
      END
