C*****  VSOCFX  Vector Scalar Offset, Clip and Fix    MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VSOCFX (A,IA,B,C,D,E,F,IF,N,IFLG)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input scalar for scaling.
C
C       C       Real input scalar for offset.
C
C       D       Real input scalar, lower threshold.
C
C       E       Real input scalar, upper threshold.
C
C       F       Integer output vector.
C
C       IF      Integer input stride for vector F.
C
C       N       Integer input element count.
C
C       IFLG    Integer input processing option flag:
C                   =0 for round on fix.
C                   =1 for truncate on fix.
C
C
C  DESCRIPTION
C
C       This routine multiplies the values of a vector A by
C       a scalar B and adds a scalar C, clipping the results
C       to within a range specified by scalars D and E.
C       Finally, the results are changed from type real to
C       type integer data and stored in vector F.
C
C            F(i) = FIX(D),         if (A(i)*B+C) < D,
C                 = FIX(A(i)*B+C),  if D <= (A(i)*B+C) < E,
C                 = FIX(E),         if E <= (A(i)*B+C)   for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VSOCFX (A,1,B,C,D,E,F,1,5,0)
C
C       Input Operands:
C
C       A = -1.000
C            0.000
C            1.000
C            2.000
C            3.000
C
C       B = 10.000
C
C       C =  5.000
C
C       D =  0.000
C
C       E = 20.000
C
C       Output Operands:
C
C       F =  0
C            5
C           15
C           20
C           20
C
C  HISTORY
C         1) May 85     D. Cooper       Original.
C
C
      SUBROUTINE VSOCFX(A,IA,B,C,D,E,F,IF,N,IFLG)
C
      INTEGER IA,F(1),IF,N,IFLG,I,J,M
      REAL A(1),B,C,D,E,X,HALF
      IF (N.LE.0 .OR. IFLG.LT.0 .OR. IFLG.GT.1) GO TO 9000
      I = 1
      J = 1
      DO 199 M=1,N
        X = A(I) * B + C
        IF (X.GE.D) GOTO 50
C ...     IF X<D then:
          X = D
          GOTO 100
50      CONTINUE
C ...     ELSE:
          IF (X.GE.E) X = E
100     IF (IFLG.EQ.0) GOTO 150
C ...     Truncate if IFLG = 1
          F(J) = IFIX(X)
          GOTO 175
150     CONTINUE
C ...     ELSE round:
          HALF  = SIGN(0.5,X)
          F(J)  = IFIX(X+HALF)
175     I = I+IA
        J = J+IF
199   CONTINUE
9000  RETURN
      END
