C*****  VSUM    Vector Running Sum Integration    MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VSUM (A,IA,C,IC,N,H)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C       H       Real input scalar, integration step size.
C
C
C  DESCRIPTION
C
C       This routine integrates a vector A by performing a
C       running scaled sum of the elements of A and stores
C       the results in C.
C
C            C(j) = H * SUM{A(i)}    for i=1,j and j=1,N
C
C
C  REFERENCE
C
C       R. Beckett and J. Hurt.  1967.  Numerical calculations
C       and algorithms.  New York: McGraw-Hill.
C
C
C  EXAMPLE
C
C       CALL VSUM (A,1,C,1,5,H)
C
C       Input Operands:
C
C       A = 1.000
C           2.000
C           1.000
C           3.000
C           5.000
C
C       H = 0.500
C
C       Output Operands:
C
C       C = 0.500
C           1.500
C           2.000
C           3.500
C           6.000
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VSUM(A,IA,C,IC,N,H)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),C(1),H
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      C(1) = H * A(1)
      IF (N.LE.1) GO TO 12
      DO 10 M=2,N
        II = II+IA
        KK = KK+IC
        C(KK) = C(KK-IC) + H*A(II)
10    CONTINUE
12    RETURN
      END
