C*****  VSWAP   Vector Swap                       MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VSWAP (A,IA,C,IC,N)
C
C       where,
C
C       A       Real input/output vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real input/output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine swaps the elements of vector A with
C       the corresponding elements of a second vector C.
C
C            C(i) = A(i), and
C            A(i) = C(i)    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VSWAP (A,1,C,1,5)
C
C       Input Operands:
C
C       A = 1.00
C           2.00
C           3.00
C           4.00
C           5.00
C
C       C = 4.00
C           2.00
C           0.00
C          -2.00
C          -4.00
C
C       Output Operands:
C
C       A = 4.00
C           2.00
C           0.00
C          -2.00
C          -4.00
C
C       C = 1.00
C           2.00
C           3.00
C           4.00
C           5.00
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VSWAP(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL C(1),A(1),SWP
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      DO 10 M=1,N
        SWP = C(KK)
        C(KK) = A(II)
        A(II) = SWP
        II = II + IA
        KK = KK + IC
10    CONTINUE
12    RETURN
      END
