C*****  VTHR   Vector Threshold                 MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VTHR (A,IA,B,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Real input scalar, lower threshold.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine clips the values of a vector A to greater
C       than the value specified by scalar B.  The results are
C       stored in vector C.
C
C            C(i) = A(i)   if A(i) >= B
C                 = B      if A(i) < B    for i=1,N
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VTHR (A,1,B,C,1,5)
C
C       Input Operands:
C
C       A = -2.000    B = -1.000
C           -1.000
C            0.000
C            1.000
C            2.000
C
C
C       Output Operands:
C
C       C = -1.000
C           -1.000
C            0.000
C            1.000
C            2.000
C
C  HISTORY
C         1) Jul 86     D. Benua        Original.
C
      SUBROUTINE VTHR(A,IA,B,C,IC,N)
C
      INTEGER IA,IC,N,II,LL,M
      REAL A(1),B,C(1)
      IF (N.LE.0) GO TO 12
      II = 1
      LL = 1
      DO 10 M=1,N
        IF (A(II).LT.B) GOTO 4
          C(LL) = A(II)
        GOTO 8
4         C(LL) = B
8       II = II+IA
        LL = LL+IC
10    CONTINUE
12    RETURN
      END
