C*****  VTRAPZ  Vector Trapezoid Rule Integrate   MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VTRAPZ (A,IA,C,IC,N,H)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C       H       Real input scalar, integration step size.
C
C
C  DESCRIPTION
C
C       This routine integrates a vector A using the
C       trapezoidal rule and stores the results in
C       vector C.
C
C            C(1) = 0.0
C            C(j) = SUM[A(i)+A(i+1)]*H/2    for i=1,j-1 and j=2,N
C
C
C  REFERENCE
C
C       R. Beckett and J. Hurt.  1967.  Numerical calculations
C       and algorithms.  New York: McGraw-Hill.
C
C
C  EXAMPLE
C
C       CALL VTRAPZ (A,1,C,1,5,H)
C
C       Input Operands:
C
C       A = 1.000
C           2.000
C           1.000
C           3.000
C           5.000
C
C       H = 0.500
C
C       Output Operands:
C
C       C = 0.000
C           0.750
C           1.500
C           2.500
C           4.500
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE VTRAPZ(A,IA,C,IC,N,H)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),C(1),H,X,Y,HOV2
      IF (N.LE.0) GO TO 12
      II = 1
      KK = 1
      X = A(1)
      C(1) = 0.0
      IF (N.LE.1) GO TO 12
      HOV2 = 0.5 * H
      DO 10 M=2,N
        II = II+IA
        KK = KK+IC
        Y = X
        X = A(II)
        C(KK) = C(KK-IC) + HOV2*(Y+X)
10    CONTINUE
12    RETURN
      END
