C*****  VXCS    Vector Multiplied by Sin and Cos  MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL VXCS (A,C,IC,F,P,N)
C
C       where,
C
C       A       Real input vector.
C
C       C       Complex output vector.
C
C       IC      Integer input stride for vector C.
C
C       F       Real input scalar frequency.
C
C       P       Real input/output scalar phase.  On input
C               P contains phase of first point.  On
C               output, P contains initial phase value for
C               next frame.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine multiplies a vector A by the sine and cosine
C       of a linearly increasing argument F with a given initial
C       phase P.
C
C            real(C(i)) = A(i) * COS((i-1)*F+P)
C            imag(C(i)) = A(i) * SIN((i-1)*F+P)     for i=1,N
C
C       The phase P is given in radians, and is always normalized
C       to be within the region:    -PI < P <= PI
C
C       F is expressed in radial units.
C
C       The initial phase value for the next frame is returned in P.
C
C
C  REFERENCE
C
C       H. G. Campbell.  1977.  An introduction to matrices,
C       vectors and linear programming.  Englewood Cliffs NJ:
C       Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL VXCS (A,C,2,F,P,5)
C
C       Input Operands:
C
C       A = 1.000
C           2.000
C           3.000
C           4.000
C           5.000
C
C       F = 1.571
C
C       P = 0.000
C
C       Output Operands:
C
C       C = ( 1.0, 0.0)
C           ( 0.0, 2.0)
C           (-3.0, 0.0)
C           ( 0.0,-4.0)
C           ( 5.0, 0.0)
C
C       P = 1.571
C
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C         2) Sep 85     D. Cooper       ECR 9/4/85--Amod P always.
C
      SUBROUTINE VXCS(A,C,IC,F,P,N)
C
      INTEGER IC,N,KK,M
      REAL A(1),C(1),F,P,THETA,PI,PI2
      IF (N.LE.0) GO TO 40
      PI = 4.0 * ATAN(1.0)
      PI2 = PI + PI
      KK = 1
      DO 30 M=1,N
        THETA = AMOD(F*FLOAT(M-1)+P,PI2)
        IF (ABS(THETA).GT.PI) THETA = THETA - SIGN(PI2,THETA)
        C(KK)   = A(M) * COS(THETA)
        C(KK+1) = A(M) * SIN(THETA)
        KK = KK+IC
30    CONTINUE
      P = AMOD(F*FLOAT(N)+P,PI2)
      IF (ABS(P).GT.PI) P = P - SIGN(PI2,P)
40    RETURN
      END
