C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
       subroutine fitvel(tt, c, nc, nsamp, dt, coefs,
     * sig, ch, vtrms, vsrms, vism, vi, iord, fit, jerr)
c ******************************************************************** c
c *   Subroutine to fit 5th order polynomial to input time-velocity  * c
c *   function and return smooth versions of rms and interval        * c
c *   velocities.                                                    * c
c *                                                                  * c
c *   INPUT:                                                         * c
c *                                                                  * c
c *      tt    - R*4() -  vector of times for vf , in secs           * c
c *       c    - R*4() -  vector of velocitis                        * c
c *      nc    - I*4   -  number of points in the vf                 * c
c *   nsamp    - I*4   -  Trace length for vf expansion/interpolation* c
c *     dt     - R*4   -  Sample interval in sec.                    * c
c *    sig     - R*4() -  Individual standard deviations             * c
c *     ch     - R*4   -  chisqr constant for polyfit routine        * c
c *                                                                  * c
c *   OUTPUT :                                                       * c
c *                                                                  * c
c *   vtrms    - R*4() -  Trace-length rms velocity  vector          * c
c *   coefs    - R*4() -  RMS Velocity coefficients                  * c
c *   vsrms    - R*4() -  smoothed rms velocity vector               * c
c *   vism     - R*4() -  smoothed interval velocity vector          * c
c *   vi       - R*4() -  "raw" interval velocities                  * c
c *                                                                  * c
c ******************************************************************** c
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      parameter (npol = 6)
      real tt(*), c(*),coefs(*),sig(*),vtrms(*)
      real vsrms(*),vism(*),vi(*)

      real work1(1), work2(1),work3(1),time(1)
      real wt(10000), wv(10000),w1(1), w2(1),w3(1)
      real work4(1), work5(1)
      POINTER (pwork1,work1),(pwork2,work2),(pwork3,work3)
      POINTER (pwork4,work4),(pwork5,work5),(ptime,time)
      POINTER (pwt,wt),(pwv,wv)
      POINTER (pw1,w1),(pw2,w2),(pw3,w3)

      real ch
      logical fit
      external fpoly
 
      jerr = 0
      jabort = 0
      iget = (nsamp+500)*ISZBYT
      call galloc(pwork1,iget,jerr,jabort)
      call galloc(pwork2,iget,jerr,jabort)
      call galloc(pwork3,iget,jerr,jabort)
      call galloc(pwork4,iget,jerr,jabort)
      call galloc(pwork5,iget,jerr,jabort)
      call galloc(pwt   ,iget,jerr,jabort)
      call galloc(pwv   ,iget,jerr,jabort)
      call galloc(ptime ,iget,jerr,jabort)
      iget= npol*nsamp*ISZBYT
      call galloc(pw1,iget,jerr,jabort)
      call galloc(pw2,iget,jerr,jabort)
      call galloc(pw3,iget,jerr,jabort)

      if(jerr.ne.0)return

      tmax = (nsamp-1)*dt
      do i=1,npol*nsamp
       w1(i)=0.
       w2(i)=0.
       w3(i)=0.
      end do
      do i=1,npol
       coefs(i)=0.
      end do
      do i = 1,nsamp
       time(i) = float(i-1)*dt
      end do
      if(fit)then
       do ii=1,nsamp
        wt(ii)=0.
        wv(ii)=0.
       end do
       do ii=1,nc
        wt(ii)=tt(ii)
        wv(ii)=c(ii)
       end do
       j=nc
       if(wt(1).gt.dt)call add_first(wt,wv,nc,j,dt)
       if(wt(j).lt.tmax)then
        call add_last(wt,wv,j,k,tmax)
        j=k
       end if
       ch =0.
       call brms(wt,wv,j,nsamp,dt,vtrms)
      else
       do i=1,nsamp
        vtrms(i)=c(i)
       end do
       do ii=1,nc
        wt(ii)=tt(ii)
        wv(ii)=c(ii)
       end do
       j=nc
      endif
      if(iord.gt.0)then
       call SmoothFit (vtrms,nsamp,iord)
      endif
      jl = j
      call infill(wt,wv,work4,work5,jl,jj)
      call psvfit(work4,work5,sig,j,coefs,npol,w1,w2,w3,j,npol,
     :ch,fpoly)
      call polev(time,nsamp,coefs,npol,vsrms)
      call rmsint(vsrms,time,nsamp,tmax,vism)
      call rmsint(vtrms,time,nsamp,tmax,vi)
      call gfree(pw1)
      call gfree(pw2)
      call gfree(pw3)
      call gfree(pwork1)
      call gfree(pwork2)
      call gfree(pwork3)
      call gfree(pwork4)
      call gfree(pwork5)
      call gfree(ptime)
      call gfree(pwt)
      call gfree(pwv)
      return
      END
