C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Linterp ( tri, nsamp, xtr, nsampo, tabl1, tabl2)

c linear interpolation done between first non - zero and last non -zero
c entry in tri[].  The time or depth value for each input sample is in 
c tabl1[] while the time or depth value for each output sample is in tabl2[].

c declare variables passed from calling routine

      integer nsamp, nsampo

      real tri( nsamp ), xtr( nsampo )
      real tabl1( nsampo ), tabl2 ( nsampo )

c declare local variables

      integer i, j, pointer

      real slope

      pointer = 2

      DO 10 i = 1, nsampo

         if ( ( tabl2(i) - tabl1(1) ) .lt. 1.e-10 ) then

c tabl2[i] < tabl1[1]  -- looking for amplitude value outside range of
c                         input trace which we will not allow [for now]
            xtr(i) = tri(1)

         elseif ( ( tabl2(i) - tabl1(nsamp) ) .gt. 1.e-10 ) then

            xtr(i) = tri(nsamp)

         else

            DO j = pointer, nsamp
               
               if ( ( tabl2(i) - tabl1(j-1) ) .ge. 1.e-10
     :              .and. ( tabl2(i) - tabl1(j) ) .le. 1.e-10 ) then

                  den =   (tabl1(j) - tabl1(j-1))
                  if (abs(den) .ne. 0.0) then
                      slope = (tabl2(i) - tabl1(j-1)) / den
                  else
                      slope = 0.0
                  endif
                  xtr(i) = tri(j-1) + slope * (tri(j) - tri(j-1))
                  pointer = j
                  goto 10
               endif

            ENDDO

         endif

 10   CONTINUE

c----
c   fill leading zeros
c----
         izero = nsampo
         do  i = 1, nsampo
             if ( xtr(i) .ne. 0.0 ) then
                izero = i
                go to 11
             endif
         enddo
11       continue
         if (izero .gt. 1 .AND. izero .lt. nsampo) then
             do  i = 1, izero-1
                 xtr(i) = xtr (izero)
             enddo
         endif

c----
c   fill trailing zeros
c----
         izero = nsampo
         do  i = nsampo, 1, -1
             if ( xtr(i) .ne. 0.0 ) then
                izero = i
                go to 13
             endif
         enddo
13       continue
         if (izero .gt. 1 .AND. izero .lt. nsampo) then
             do  i = nsamp, izero+1, -1
                 xtr(i) = xtr (izero)
             enddo
         endif


      return
      end

         
