C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getw8(w,ndiv)
c
      real      w(-3:+4,0:ndiv)
c_____________________________________________________________________
c     calculate 8 point lagrange interpolation for equally spaced     
c     input data for a table of divisions.
c
c     from Abramawitz and Stegun
c        formula 25.2.6
c_____________________________________________________________________
      dp=1./ndiv
      do 20000 idiv=0,ndiv
       p=idiv*dp
       w(-3,idiv)=-      (p+2)*(p+1)*p*(p-1)*(p-2)*(p-3)*(p-4)/5040.
       w(-2,idiv)=+(p+3)      *(p+1)*p*(p-1)*(p-2)*(p-3)*(p-4)/720. 
       w(-1,idiv)=-(p+3)*(p+2)      *p*(p-1)*(p-2)*(p-3)*(p-4)/240. 
       w(-0,idiv)=+(p+3)*(p+2)*(p+1)*  (p-1)*(p-2)*(p-3)*(p-4)/144. 
       w(+1,idiv)=-(p+3)*(p+2)*(p+1)*p      *(p-2)*(p-3)*(p-4)/144. 
       w(+2,idiv)=+(p+3)*(p+2)*(p+1)*p*(p-1)      *(p-3)*(p-4)/240. 
       w(+3,idiv)=-(p+3)*(p+2)*(p+1)*p*(p-1)*(p-2)      *(p-4)/720. 
       w(+4,idiv)=+(p+3)*(p+2)*(p+1)*p*(p-1)*(p-2)*(p-3)      /5040.
20000 continue
C
      return   
      end
