C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine nmo3dsub(iuin,uin,iuout,uout,
     1                  t0,t02,tnmo,shot,rcvr,cdp,
     2                  slow,slow2,v,dt,
     2                  wgt,jleft,jdiv,adiv,ndiv,
     3                  irs,ire,ns,ne,ntrc,obytes,remove,stat,
     4                  minsamp,nsamp,nsampin,nsampout,nsamporig,
     5                  vrs,vre,nrecv,vflag,ntrcv,factor,
     6                  hbegin,lenhed,lerr,luin,luout,luvel,xyscl,
     7                  t0irreg,top2bot,bot2top,linear,d3,scl,XYs,
     8 ifmt_StaCor,l_StaCor,ln_StaCor,ifmt_DstSgn,l_DstSgn,ln_DstSgn,
     9 ifmt_DphInd,l_DphInd,ln_DphInd,ifmt_LinInd,l_LinInd,ln_LinInd,
     a ifmt_hdrwrdx,l_hdrwrdx,ln_hdrwrdx,ifmt_hdrwrdy,l_hdrwrdy,
     b ln_hdrwrdy,IX1,IY1,XX,XY,YX,YY,XXT,XYT,YXT,YYT,DX,DY,NDI,NLI,
     c ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,
     d ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,
     e limin,limax,dimin,dimax,verbos,tabl1,tabl2,vwork,nsampv,rsamp,
     f lidel,didel,iout,drop)
c

      integer   hbegin
      integer   iuin(*),iuout(*)
      real      uin(hbegin:nsampin)
      real      uout(hbegin:nsampout)
      real      v(hbegin:nsamporig)
      real      slow(0:nsamporig-1)
      real      slow2(0:nsamporig-1)
      real      t0(0:nsamporig-1)
      real      t02(0:nsamporig-1)
      real      tnmo(0:nsamporig-1)
      real      t0irreg(0:nsamporig-1)
      real      wgt(*)             
      integer   jleft(0:nsamporig-1),jdiv(0:nsamporig-1)
      real      tabl1(nsamporig), tabl2(nsamporig), vwork(nsamporig)
      REAL*8    XX, XY, YX, YY, XXT, XYT, YXT, YYT
c
      integer irs,ire,ns,ne
      integer limin,limax,dimin,dimax,lidel,didel,iout
      integer vrs,vre,nrecv,ntrcv,vflag
      integer obytes
      integer l_StaCor                             
      logical stat,remove
      logical top2bot,bot2top
      logical linear,d3,XYs,shot,rcvr,cdp,verbos,rsamp,drop

      nsampo = nsamporig

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,1)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,1)

C______________________________________________________________________
C     calculate (only once):
c  
c     t0........the normal incidence time
c     t02.......the normal incidence time squared
c______________________________________________________________________
      do 10000 k=0,nsamporig-1
       t0(k)=k
       t02(k)=t0(k)**2
10000 continue
c______________________________________________________________________
c     skip past velocity records:
c______________________________________________________________________
      nvbytes=1
      if(vflag .eq. 1) then
c______________________________________________________________________
c        multiple velocity functions
c______________________________________________________________________
         if(vrs .le. nrecv) then
            call recskp(1,vrs-1,luvel,ntrcv,v(hbegin))
         else
            write(lerr,*)'start record to skip to exceeds number'
            write(lerr,*)'records on velocity file'
            write(lerr,*)'check velin run to make sure your velocity'
            write(lerr,*)'model covers the part of the data between'
            write(lerr,*)'records ',vrs,' and ', vre
            write(lerr,*)'program terminated in routine nmosub'
            call exit(5666)
         endif
      elseif (vflag .eq. 0) then
c______________________________________________________________________
c        single velocity function:  read him right away
c______________________________________________________________________
         nvbytes=0
         call rtape(luvel,v(hbegin),nvbytes)
         if(nvbytes .eq. 0) then
            write(lerr,*)'End of file on velocity file: FATAL'
            write(lerr,*)'single velocity function anticipated'
            write(lerr,*)'program terminated in routine nmosub'
            call exit(6666)
         endif

          if (rsamp) then

             call Linterp (v(1), nsampv, vwork, nsampo, tabl1, tabl2)

          else

             call vmov (v(1), 1, vwork, 1, nsampv)
             if (nsampv .lt. nsampo) then
                 do  i = nsampv+1, nsampo
                     vwork (i) = vwork (nsampv)
                 enddo
             endif

          endif

c_____________________________________________________________________
c         heuristic to check for valid velocities.
c_____________________________________________________________________
          call dotpr (vwork,1,vwork,1,vdot,nsamporig)
          if(abs(vdot) .lt. 1.e-06) then
             write(lerr,*)'Velocity trace contains zeros'
             write(lerr,*)'---    FATAL  ---'
             write(lerr,*)'Check the velin step thoroughly'
             go to 99999
          endif
C______________________________________________________________________
C         calculate the slowness and slowness squared:
C______________________________________________________________________
          do 20001 k=0,nsamporig-1
           slow(k)=1./vwork(k+1)
           slow2(k)=1./vwork(k+1)**2
20001     continue
      endif
c______________________________________________________________________
c     skip past seismic records:                             
c______________________________________________________________________
      call recskp(1,irs-1,luin,ntrc,uin(hbegin))
c--------------------------------------------------------------------
c     loop over record/gathers to process.
c--------------------------------------------------------------------
      do 90000 irec=irs,ire
c______________________________________________________________________
c      skip over beginning undesired traces in this seismic gather.
c______________________________________________________________________
       call trcskp(irec,1,ns-1,luin,ntrc,uin(hbegin))
c______________________________________________________________________
c      process traces that fall within the processing window.
c______________________________________________________________________
       do 30000 itrace=ns,ne

        nbytes = 0
        call rtape(luin,uin(hbegin),nbytes)
        if(nbytes .eq. 0) then
           write(lerr,*)'End of file on input:'
           write(lerr,*)'  rec= ',irec,'  trace= ',itrace
           go to 99999
        endif
        call saver2(iuin,ifmt_StaCor,l_StaCor, ln_StaCor,
     1              istatic, 1)
        call saver2(iuin,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1              idis   , 1)
        call saver2(iuin,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1              itt    , 1)

        IF (istatic .ne. 30000) THEN

            if (XYs) then

               call saver2(iuin,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                     ISX     , 1)
               call saver2(iuin,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1                     ISY     , 1)
               SX = xyscl * float(ISX)
               SY = xyscl * float(ISY)
               call saver2(iuin,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                     IRX     , 1)
               call saver2(iuin,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1                     IRY     , 1)
               RX = xyscl * float(IRX)
               RY = xyscl * float(IRY)

               DXT  = ISX - IRX
               DYT  = ISY - IRY
               x    = sqrt ( DXT*DXT + DYT*DYT ) + 0.5

               if (shot .OR. rcvr) then
                  call saver2(iuin,ifmt_hdrwrdx,l_hdrwrdx, ln_hdrwrdx,
     1                        IXC     , 1)
                  call saver2(iuin,ifmt_hdrwrdy,l_hdrwrdy, ln_hdrwrdy,
     1                        IYC     , 1)
               else
                  IXC = 0.5 * float (ISX + IRX) + 0.5
                  IYC = 0.5 * float (ISY + IRY) + 0.5
               endif
               XC = xyscl * float(IXC)
               YC = xyscl * float(IYC)
               CALL XFMFWD (XC, YC, LI, IDI, SXT, SYT,BXT,BYT,IWRN,
     1                      IX1, IY1, XX, XY, YX, YY, XXT,XYT,YXT,YYT,
     2                      DX, DY, NDI, NLI)

               if (li .lt. 1 .OR. li .gt. NLI) then
                  if (drop) then
                     write(LERR,*)'LI ',li,' outside survey box: drop'
                     iout = iout + 1
                     go to 30000
                  else
                     write(LERR,*)'LI ',li,' outside survey box: zero'
                     call savew2(iuin,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                           30000, 1)
                     call vclr (uout(1), 1, nsampout)
                     iout = iout + 1
                     go to 29999
                  endif
               endif

               if (idi .lt. 1 .OR. idi .gt. NDI) then
                  if (drop) then
                     write(LERR,*)'DI ',idi,' outside survey box: drop'
                     iout = iout + 1
                     go to 30000
                  else
                     write(LERR,*)'DI ',idi,' outside survey box: zero'
                     call savew2(iuin,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                           30000, 1)
                     call vclr (uout(1), 1, nsampout)
                     iout = iout + 1
                     go to 29999
                  endif
               endif

            else

               x = idis
               call saver2(iuin,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                     idi    , 1)
               call saver2(iuin,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                     li     , 1)

               if (idi .lt. dimin .OR. idi .gt. dimax) then
                  if (drop) then
                     write(LERR,*)'DI ',idi,' outside survey box: drop'
                     iout = iout + 1
                     go to 30000
                  else
                     write(LERR,*)'DI ',idi,' outside survey box: zero'
                     call savew2(iuin,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                           30000, 1)
                     call vclr (uout(1), 1, nsampout)
                     iout = iout + 1
                     go to 29999
                  endif
               endif
               if (li .lt. limin .OR. li .gt. limax) then
                  if (drop) then
                     write(LERR,*)'LI ',li,' outside survey box: drop'
                     iout = iout + 1
                     go to 30000
                  else
                     write(LERR,*)'LI ',li,' outside survey box: zero'
                     call savew2(iuin,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                           30000, 1)
                     call vclr (uout(1), 1, nsampout)
                     iout = iout + 1
                     go to 29999
                  endif
               endif

            endif

c_____________________________________________________________________
c          live trace.
c          check if we wish to apply static correction.
c______________________________________________________________________
           if(stat) then
              tstatic=float(istatic)/dt
           else
              tstatic=0.
           endif
c_____________________________________________________________________
c         read in the next velocity trace.
c         don't  stop the program if we run out.                       
c_____________________________________________________________________
          nvbytes=0
c         if (d3) then
             iptli = (li  - limin) / lidel + 1
             iptdi = (idi - dimin) / didel + 1
             call sisseek(luvel,(iptli-1)*ntrcv + iptdi)
c         endif
          call rtape(luvel,v(hbegin),nvbytes)
          call saver2(v(hbegin),ifmt_DphInd,l_DphInd, ln_DphInd,
     1                idv    , 1)
          call saver2(v(hbegin),ifmt_LinInd,l_LinInd, ln_LinInd,
     1                liv    , 1)
c         call saver2(v(hbegin),ifmt_TrcNum,l_TrcNum, ln_TrcNum,
c    1                ittt    , 1)
c         call saver2(v(hbegin),ifmt_RecNum,l_RecNum, ln_RecNum,
c    1                irrr    , 1)

          if (verbos .AND. itt .eq. 1) then
          write(LERR,223)li,idi,liv,idv
223       format('Data gather LI/DI ',2i6,5x,' Vel ',2i6)
          endif

          if (rsamp) then

             call Linterp (v(1), nsampv, vwork, nsampo, tabl1, tabl2)

          else

             call vmov (v(1), 1, vwork, 1, nsampv)
             if (nsampv .lt. nsampo) then
                 do  i = nsampv+1, nsampo
                     vwork (i) = vwork (nsampv)
                 enddo
             endif

          endif

c_____________________________________________________________________
c         heuristic check for valid velocities.
c_____________________________________________________________________
          call dotpr (vwork,1,vwork,1,vdot,nsamporig)
          if (scl .ne. 1.0) then
             call vsmul (vwork(1), 1, scl, vwork(1), 1, nsamporig)
          endif
          if(abs(vdot) .lt. 1.e-06) then
             if (drop) then
               write(lerr,444)idv,liv,li,idi
444            format('Zero vel trc at LI/DI ',2i6,
     1                ' Drop trc LI/DI ',2i6)
               iout = iout + 1
               go to 30000
             else
               write(lerr,445)idv,liv,li,idi
445            format('Zero vel trc at LI/DI ',2i6,
     1                ' Zero trc LI/DI ',2i6)
               call savew2(iuin,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                     30000, 1)
               call vclr (uout(1), 1, nsampout)
               iout = iout + 1
               go to 29999
             endif
          endif
C______________________________________________________________________
C         calculate the slowness squared:             
C______________________________________________________________________
          do 20000 k=0,nsamporig-1
           slow(k)=1./vwork(k+1)
           slow2(k)=1./vwork(k+1)**2
20000     continue
           if(.not. remove) then
C______________________________________________________________________
C             perform the forward nmo correction.                 
c______________________________________________________________________
              call nmof(uin(1),uout(1),dt,minsamp,nsamporig, 
     1                 x,vwork(1),slow,slow2,t0,t02,tnmo,tstatic,factor,
     2                 jleft,wgt,jdiv,ndiv,adiv,linear)
           else
c______________________________________________________________________
c             perform the reverse nmo correction.                 
c______________________________________________________________________
              call nmor(uin(1),uout(1),dt,minsamp,nsamporig,
     1                 x,vwork(1),slow,slow2,t0,t02,tnmo,tstatic,factor,
     2                 t0irreg,wgt,ndiv,adiv,bot2top,top2bot,
     3                 jleft,jdiv,linear) 

           endif

        ELSE

c_____________________________________________________________________
c          dead trace. zero it out.
c______________________________________________________________________
           call vclr(uout(1),1,nsampout)

        ENDIF
c______________________________________________________________________
c       copy the input trace header to the output trace.
c       write out the output trace header and data.                        
c______________________________________________________________________
29999   continue
        call vmov(uin(hbegin),1,uout(hbegin),1,lenhed)
        call wrtape(luout,uout(hbegin),obytes)
30000  continue
c______________________________________________________________________
c      skip over ending undesired traces in this seismic gather.
c______________________________________________________________________
       call trcskp(irec,ne+1,ntrc,luin,ntrc,uin(hbegin))
90000 continue
99999 continue
c
      return
      end
