C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                WHERE: XC   - input X-COORDINATE OF POINT IN QUESTION
C                       YC   - input Y-COORDINATE OF POINT IN QUESTION
C                       ILI  - input LINE INDEX OF (XC,YC)
C                       IDI  - input DEPTH INDEX OF (XC,YC)
C                       XT   - TRANSFORMED X-COORDINATE
C                       YT   - TRANSFORMED Y-COORDINATE
C                       XTBC - TRANSFORMED X-COORDINATE BIN CENTER 
C                       YTBC - TRANSFORMED Y-COORDINATE BIN CENTER
C                   
      SUBROUTINE Coordinate_Transform ( XC, YC, ILI, IDI, XT, YT,
     :     XTBC, YTBC, IWARN, IX1, IY1, XX, XY, YX, YY, XXT, XYT, YXT, 
     :     YYT, DX, DY, NDI, NLI)

      integer ili, idi, ndi, nli, IX1, IY1, iwarn

      real XC, YC, DX, DY, YTBC, XTBC, XT, YT

      REAL*8  XX    , XY    , YX    , YY
      REAL*8  XXT   , XYT   , YXT   , YYT

      iwarn = 0

      ILI = nint( (XC-float(IX1)) * sngl(XX) + (YC-float(IY1)) * 
     :     sngl(XY) + 0.999999 )
      IDI = nint( (XC-float(IX1)) * sngl(YX) + (YC-float(IY1)) * 
     :     sngl(YY) + 0.999999 )

      XT = (XC-float(IX1)) * sngl(XXT) + (YC-float(IY1)) * sngl(XYT)
      YT = (XC-float(IX1)) * sngl(YXT) + (YC-float(IY1)) * sngl(YYT)

      XTBC = (DX * float(ILI)) - (DX / 2.0)
      YTBC = (DY * float(IDI)) - (DY / 2.0)

C-----------------------------------------------------------------------
C                                                                       
C     SEE IF POINT IS WITHIN GRID BOUNDARIES                            
C                                                                       
C-----------------------------------------------------------------------

      IF(ILI .LE. 0 .OR. ILI .GT. NLI) IWARN = 1
      IF(IDI .LE. 0 .OR. IDI .GT. NDI) IWARN = 1

      RETURN 
      END
