C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine XsdReadPicks(lupick, Record, Trace, Sample, 
     :     N, NumEntries, Xsd_SegNum, Xsd_SegName, Xsd_SegColor, verbos)

c XSDRead reads one arbitary traverse segment from an attached pick file

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer lupick, NumEntries, N

      real   Record(NumEntries), Trace(NumEntries), Sample(NumEntries) 

      logical verbos

c declare variables used in subroutine

      integer     counter, Xsd_SegNum, Xsd_SegColor

      real        RecordIndexBuffer(SZSMPM), TraceIndexBuffer(SZSMPM)
      real        SampleIndexBuffer(SZSMPM)

      character   Xsd_SegName*20

c initialize memory

      call vclr(RecordIndexBuffer,1,NumEntries)
      call vclr(TraceIndexBuffer,1,NumEntries)
      call vclr(SampleIndexBuffer,1,NumEntries)
      counter = 0

c read segment header

      read(lupick,'(10x,i5,6x,a20,10x,i5,9x,i5)', err=900, end=901) 
     :     Xsd_SegNum, Xsd_SegName, Xsd_SegColor, N

c read Trace function picks
      do k = 1, N
         read(lupick, '(f12.6,1x,f12.6,1x,f12.6)', err=900, end=1001)  
     :        RecordIndexBuffer(k), TraceIndexBuffer(k), 
     :        SampleIndexBuffer(k)
      enddo

c build first output (record, Trace, Sample) entry

      counter = 1
      Trace(counter) = TraceIndexBuffer(counter)
      Record(counter) = RecordIndexBuffer(counter)
      Sample(counter) = SampleIndexBuffer(counter)

c POLICEMAN: watch out for duplicate picks in the pickfile

      do j = 2, N

         if ( RecordIndexBuffer(j) .eq. Record(j-1)
     :        .and.
     :        TraceIndexBuffer(j) .eq. TraceIndexBuffer(j-1)
     :        .and. 
     :        SampleIndexBuffer(j) .eq. Sample(j-1) ) then

            write(LERR,*)' '
            write(LERR,*)'Duplicate entry occurred in Pickfile'
            write(LERR,*)'at record & Trace entries: '
     :           ,RecordIndexBuffer(j), TraceIndexBuffer(j)
            write(LERR,*)'Will fix by deleting 2nd occurrence'
            write(LERR,*)' '
            
         else

            counter = counter + 1
            Record(counter) = RecordIndexBuffer(j)
            Trace(counter) = TraceIndexBuffer(j)
            Sample(counter) = SampleIndexBuffer(j) 
            
         endif
      enddo

      N = counter

      return

1001  continue

      N = counter
      return

 900  continue
      write(LERR,*)' '
      write(LERR,*)' AT3D: Error reading input Trace function set'
      write(LERR,*)' FATAL' 
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' AT3D: Error reading input Trace function set'
      write(LER,*)' FATAL' 
      write(LER,*)' '
      stop

  901  continue
      write(LERR,*)' '
      write(LERR,*)' AT3D: Premature EOF on input Trace dataset'
      write(LERR,*)' FATAL' 
      write(LERR,*)' '
      write(LER,*)' '
      write(LER,*)' AT3D: Premature EOF on input Trace dataset'
      write(LER,*)' FATAL' 
      write(LER,*)' '
      stop

      end
