C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C
C     SUBROUTINE NAME:  NAYBOR  (NEIGHBORHOOD)

C     ABSTRACT:  FIND THE FOUR CDP BIN CENTERS ABOUT A SPECIFIED
C                COORDINATE.  THE LINE INDEXES, DEPTH INDEXES, AND
C                THE ASSOCIATED (X,Y) COORDINATES ARE RETURNED.
C
C     CALLING SEQUENCE:  CALL NAYBOR (LI    , DI    , XT    , YT    ,
C                                     XTBC  , YTBC  , DX    , DY    ,
C                                     LIS   , DIS   , XTBCS , YTBCS ,
C                                     INCRLI, INCRDI)
C
C                WHERE:  LI     - LINE  INDEX OF POINT
C                        DI     - DEPTH INDEX OF POINT
C                        XT     - TRANSFORMED X-COORDINATE OF POINT
C                        YT     - TRANSFORMED Y-COORDINATE OF POINT
C                        XTBC   - TRANSFORMED X-COORDINATE OF BIN
C                                 CENTER OF POINT
C                        YTBC   - TRANSFORMED Y-COORDINATE OF BIN
C                                 CENTER OF POINT
C                        DX     - IN-LINE    CELL DIMENSION
C                        DY     - CROSS-LINE CELL DIMENSION
C                        LIS    - LINE  INDEXES BUFFER OF 4 NEIGHBORS
C                        DIS    - DEPTH INDEXES BUFFER OF 4 NEIGHBORS
C                        XTBCS  - BIN CENTER X-COORDINATES BUFFER OF
C                                 FOUR NEIGHBORS
C                        YTBCS  - BIN CENTER Y-COORDINATES BUFFER OF
C                                 FOUR NEIGHBORS
C                        INCRLI - INPUT LINE  INDEX INCREMENT
C                        INCRDI - INPUT DEPTH INDEX INCREMENT
C
C     MODIFICATION HISTORY:  ??/??/?? - ?.?.
C                            INITIAL RELEASE
C                            05/03/84 - G.S. - VERSION AT3DAC
C                            ALLOW FOR INPUT LI,DI NUMBER INCREMENTS
C                            OTHER THAN ONE.
C
C
C***********************************************************************
C

      SUBROUTINE NAYBOR (LI, DI, XT, YT,
     *     XTBC, YTBC, DX, DY,
     *     LIS, DIS, XTBCS, YTBCS, INCRLI, INCRDI)

C DECLARATIONS, DEFINITIONS, & INITIALIZATIONS

      INTEGER LIS(4), DIS(4)
      INTEGER LI, LI1, LI2
      INTEGER DI, DI1, DI2

      REAL XTBCS(4), YTBCS(4)

      LI1 = LI
      DI1 = DI
      XTBC1 = XTBC
      YTBC1 = YTBC

C DETERMINE WHERE POINT IS IN THE X DIRECTION

      IF(XT .GE. XTBC) GO TO 100

      DI1 = DI1 - INCRDI
      XTBC1 = XTBC1 - DX
      DI2 = DI
      XTBC2 = XTBC

      GO TO 200

 100  continue

      DI2 = DI1 + INCRDI
      XTBC2 = XTBC1 + DX

C DETERMINE WHERE POINT IS IN THE Y DIRECTION

  200 continue

      IF(YT .GE. YTBC) GO TO 300

      LI1 = LI1 - INCRLI
      YTBC1 = YTBC1 - DY
      LI2 = LI
      YTBC2 = YTBC

      GO TO 400

  300 LI2 = LI1 + INCRLI
      YTBC2 = YTBC1 + DY

C PLACE INFORMATION IN APPROPRIATE BUFFERS IN LI CONSTANT ORDER

  400 continue

      LIS(1) = LI1
      DIS(1) = DI1
      LIS(2) = LI1
      DIS(2) = DI2
      LIS(3) = LI2
      DIS(3) = DI1
      LIS(4) = LI2
      DIS(4) = DI2

      XTBCS(1) = XTBC1
      YTBCS(1) = YTBC1
      XTBCS(2) = XTBC2
      YTBCS(2) = YTBC1
      XTBCS(3) = XTBC1
      YTBCS(3) = YTBC2
      XTBCS(4) = XTBC2
      YTBCS(4) = YTBC2

C THAT'S ALL -- RETURN TO CALLING ROUTINE

      RETURN
      END
